/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.util.concurrent.Callable;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.active.NoRetryPolicyFactory;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.IRetryPolicy;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecoveryTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Level level = Level.INFO;
    private final ActiveEntityEventsListener listener;
    private volatile boolean cancelRecovery = false;
    private final IRetryPolicyFactory retryPolicyFactory;
    private final MetadataProvider metadataProvider;
    private final IClusterStateManager clusterStateManager;

    public RecoveryTask(ICcApplicationContext appCtx, ActiveEntityEventsListener listener, IRetryPolicyFactory retryPolicyFactory) {
        this.listener = listener;
        this.retryPolicyFactory = retryPolicyFactory;
        this.metadataProvider = new MetadataProvider(appCtx, null);
        this.clusterStateManager = appCtx.getClusterStateManager();
    }

    public Callable<Void> recover() {
        if (this.retryPolicyFactory == NoRetryPolicyFactory.INSTANCE) {
            return () -> null;
        }
        IRetryPolicy policy = this.retryPolicyFactory.create((IActiveEntityEventsListener)this.listener);
        return () -> {
            Thread.currentThread().setName("RecoveryTask (" + this.listener.getEntityId() + ")");
            this.doRecover(policy);
            return null;
        };
    }

    public void cancel() {
        this.cancelRecovery = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeOrRecover(MetadataProvider metadataProvider) throws HyracksDataException {
        try {
            ActiveEntityEventsListener activeEntityEventsListener = this.listener;
            synchronized (activeEntityEventsListener) {
                this.listener.doResume(metadataProvider);
                this.listener.setState(ActivityState.RUNNING);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Attempt to resume " + this.listener.getEntityId() + " Failed", (Throwable)e);
            ActiveEntityEventsListener activeEntityEventsListener = this.listener;
            synchronized (activeEntityEventsListener) {
                if (this.listener.getState() == ActivityState.RESUMING) {
                    this.listener.setState(ActivityState.TEMPORARILY_FAILED);
                }
            }
            if (this.retryPolicyFactory == NoRetryPolicyFactory.INSTANCE) {
                activeEntityEventsListener = this.listener;
                synchronized (activeEntityEventsListener) {
                    if (!this.cancelRecovery) {
                        this.listener.setState(ActivityState.STOPPED);
                        this.listener.setRunning(metadataProvider, false);
                    }
                }
            } else {
                LOGGER.log(Level.WARN, "Submitting recovery task for " + this.listener.getEntityId());
                metadataProvider.getApplicationContext().getServiceContext().getControllerService().getExecutor().submit(() -> this.doRecover(this.retryPolicyFactory.create((IActiveEntityEventsListener)this.listener)));
            }
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    protected Void doRecover(IRetryPolicy policy) throws AlgebricksException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[MONITOR]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

