/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryStatusApiServlet
extends AbstractQueryApiServlet {
    private static final Logger LOGGER = LogManager.getLogger();

    public QueryStatusApiServlet(ConcurrentMap<String, Object> ctx, IApplicationContext appCtx, String ... paths) {
        super(appCtx, ctx, paths);
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        String strHandle = this.localPath(request);
        ResultHandle handle = ResultHandle.parse(strHandle);
        if (handle == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        ResultReader resultReader = new ResultReader(this.getResultSet(), handle.getJobId(), handle.getResultSetId());
        ResultJobRecord.Status resultReaderStatus = resultReader.getStatus();
        if (resultReaderStatus == null) {
            LOGGER.log(Level.INFO, "No results for: \"" + strHandle + "\"");
            response.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        AbstractQueryApiServlet.ResultStatus resultStatus = this.resultStatus(resultReaderStatus);
        Exception ex = this.extractException(resultReaderStatus);
        StringWriter stringWriter = new StringWriter();
        PrintWriter resultWriter = new PrintWriter(stringWriter);
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
        HttpResponseStatus httpStatus = HttpResponseStatus.OK;
        resultWriter.print("{\n");
        ResultUtil.printStatus(resultWriter, resultStatus, ex != null || AbstractQueryApiServlet.ResultStatus.SUCCESS == resultStatus);
        if (AbstractQueryApiServlet.ResultStatus.SUCCESS == resultStatus) {
            String servletPath = this.servletPath(request).replace("status", "result");
            String resHandle = "http://" + this.host(request) + servletPath + strHandle;
            QueryStatusApiServlet.printHandle(resultWriter, resHandle, false);
        } else if (ex != null) {
            ResultUtil.printError(resultWriter, ex, false);
        }
        resultWriter.print("}\n");
        resultWriter.flush();
        String result = stringWriter.toString();
        response.setStatus(httpStatus);
        response.writer().print(result);
        if (response.writer().checkError()) {
            LOGGER.warn("Error flushing output writer");
        }
    }

    AbstractQueryApiServlet.ResultStatus resultStatus(ResultJobRecord.Status status) {
        switch (status.getState()) {
            case IDLE: 
            case RUNNING: {
                return AbstractQueryApiServlet.ResultStatus.RUNNING;
            }
            case SUCCESS: {
                return AbstractQueryApiServlet.ResultStatus.SUCCESS;
            }
            case FAILED: {
                return AbstractQueryApiServlet.ResultStatus.FAILED;
            }
        }
        return AbstractQueryApiServlet.ResultStatus.FATAL;
    }

    Exception extractException(ResultJobRecord.Status status) {
        switch (status.getState()) {
            case FAILED: {
                List exceptions = status.getExceptions();
                if (exceptions != null && !exceptions.isEmpty()) {
                    return (Exception)exceptions.get(0);
                }
                return null;
            }
        }
        return null;
    }
}

