/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.ExecutionWarning;
import org.apache.asterix.api.http.server.QueryServiceRequestParameters;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.translator.RequestParameters;
import org.apache.asterix.common.api.Duration;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.aql.parser.TokenMgrError;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.ExecutionPlansJsonPrintUtil;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorContext;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.ResultProperties;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryServiceServlet
extends AbstractQueryApiServlet {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final ILangExtension.Language queryLanguage;
    private final ILangCompilationProvider compilationProvider;
    private final IStatementExecutorFactory statementExecutorFactory;
    private final IStorageComponentProvider componentProvider;
    private final IStatementExecutorContext queryCtx;
    protected final IServiceContext serviceCtx;
    protected final Function<IServletRequest, Map<String, String>> optionalParamProvider;
    protected String hostName;

    public QueryServiceServlet(ConcurrentMap<String, Object> ctx, String[] paths, IApplicationContext appCtx, ILangExtension.Language queryLanguage, ILangCompilationProvider compilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider componentProvider, Function<IServletRequest, Map<String, String>> optionalParamProvider) {
        super(appCtx, ctx, paths);
        this.queryLanguage = queryLanguage;
        this.compilationProvider = compilationProvider;
        this.statementExecutorFactory = statementExecutorFactory;
        this.componentProvider = componentProvider;
        this.queryCtx = (IStatementExecutorContext)ctx.get("org.apache.asterix.RUNINNG_QUERIES");
        this.serviceCtx = (IServiceContext)ctx.get("org.apache.asterix.SERVICE_CONTEXT");
        this.optionalParamProvider = optionalParamProvider;
        try {
            this.hostName = InetAddress.getByName(this.serviceCtx.getAppConfig().getString((IOption)CCConfig.Option.CLUSTER_PUBLIC_ADDRESS)).getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Reverse DNS not properly configured, CORS defaulting to localhost", (Throwable)e);
            this.hostName = "localhost";
        }
    }

    protected void post(IServletRequest request, IServletResponse response) {
        try {
            this.handleRequest(request, response);
        }
        catch (IOException e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
        }
        catch (Throwable th) {
            try {
                GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, th.getMessage(), th);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw th;
        }
    }

    protected void options(IServletRequest request, IServletResponse response) throws Exception {
        if (request.getHeader((CharSequence)"Origin") != null) {
            response.setHeader((CharSequence)"Access-Control-Allow-Origin", (Object)request.getHeader((CharSequence)"Origin"));
        }
        response.setHeader((CharSequence)"Access-Control-Allow-Headers", (Object)"Origin, X-Requested-With, Content-Type, Accept");
        response.setStatus(HttpResponseStatus.OK);
    }

    private static String getParameterValue(String content, String attribute) {
        if (content == null || attribute == null) {
            return null;
        }
        int sc = content.indexOf(59);
        if (sc < 0) {
            return null;
        }
        int eq = content.indexOf(61, sc + 1);
        if (eq < 0) {
            return null;
        }
        if (content.substring(sc + 1, eq).trim().equalsIgnoreCase(attribute)) {
            return content.substring(eq + 1).trim().toLowerCase();
        }
        return null;
    }

    private static String toLower(String s) {
        return s != null ? s.toLowerCase() : s;
    }

    private static SessionConfig.OutputFormat getFormat(String format) {
        if (format != null) {
            if (format.startsWith("text/csv")) {
                return SessionConfig.OutputFormat.CSV;
            }
            if (format.equals("application/x-adm")) {
                return SessionConfig.OutputFormat.ADM;
            }
            if (QueryServiceServlet.isJsonFormat(format)) {
                return Boolean.parseBoolean(QueryServiceServlet.getParameterValue(format, Attribute.LOSSLESS.str())) ? SessionConfig.OutputFormat.LOSSLESS_JSON : SessionConfig.OutputFormat.CLEAN_JSON;
            }
        }
        return SessionConfig.OutputFormat.CLEAN_JSON;
    }

    private static SessionOutput createSessionOutput(QueryServiceRequestParameters param, String handleUrl, PrintWriter resultWriter) {
        SessionOutput.ResultDecorator resultPrefix = ResultUtil.createPreResultDecorator();
        SessionOutput.ResultDecorator resultPostfix = ResultUtil.createPostResultDecorator();
        SessionOutput.ResultAppender appendHandle = ResultUtil.createResultHandleAppender(handleUrl);
        SessionOutput.ResultAppender appendStatus = ResultUtil.createResultStatusAppender();
        SessionConfig.OutputFormat format = QueryServiceServlet.getFormat(param.getFormat());
        SessionConfig.PlanFormat planFormat = SessionConfig.PlanFormat.get((String)param.getPlanFormat(), (String)param.getPlanFormat(), (SessionConfig.PlanFormat)SessionConfig.PlanFormat.JSON, (Logger)LOGGER);
        SessionConfig sessionConfig = new SessionConfig(format, planFormat);
        sessionConfig.set("format-wrapper-array", true);
        sessionConfig.set("oob-expr-tree", param.isExpressionTree());
        sessionConfig.set("oob-rewritten-expr-tree", param.isRewrittenExpressionTree());
        sessionConfig.set("oob-logical-plan", param.isLogicalPlan());
        sessionConfig.set("oob-optimized-logical-plan", param.isOptimizedLogicalPlan());
        sessionConfig.set("oob-hyracks-job", param.isJob());
        sessionConfig.set("indent-json", param.isPretty());
        sessionConfig.set("quote-record", format != SessionConfig.OutputFormat.CLEAN_JSON && format != SessionConfig.OutputFormat.LOSSLESS_JSON);
        sessionConfig.set("format-csv-header", format == SessionConfig.OutputFormat.CSV && "present".equals(QueryServiceServlet.getParameterValue(param.getFormat(), Attribute.HEADER.str())));
        return new SessionOutput(sessionConfig, resultWriter, resultPrefix, resultPostfix, appendHandle, appendStatus);
    }

    private static void printClientContextID(PrintWriter pw, QueryServiceRequestParameters params) {
        if (params.getClientContextID() != null && !params.getClientContextID().isEmpty()) {
            ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.CLIENT_ID.str(), params.getClientContextID());
        }
    }

    private static void printSignature(PrintWriter pw, QueryServiceRequestParameters param) {
        if (param.isSignature()) {
            pw.print("\t\"");
            pw.print(AbstractQueryApiServlet.ResultFields.SIGNATURE.str());
            pw.print("\": {\n");
            pw.print("\t");
            ResultUtil.printField(pw, "*", "*", false);
            pw.print("\t},\n");
        }
    }

    private static void printType(PrintWriter pw, SessionConfig sessionConfig) {
        switch (sessionConfig.fmt()) {
            case ADM: {
                ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.TYPE.str(), "application/x-adm");
                break;
            }
            case CSV: {
                String contentType = "text/csv; header=" + (sessionConfig.is("format-csv-header") ? "present" : "absent");
                ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.TYPE.str(), contentType);
                break;
            }
        }
    }

    private static void printMetrics(PrintWriter pw, long elapsedTime, long executionTime, long resultCount, long resultSize, long processedObjects, long errorCount, long warnCount) {
        boolean hasErrors = errorCount != 0L;
        boolean hasWarnings = warnCount != 0L;
        pw.print("\t\"");
        pw.print(AbstractQueryApiServlet.ResultFields.METRICS.str());
        pw.print("\": {\n");
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.ELAPSED_TIME.str(), Duration.formatNanos((long)elapsedTime));
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.EXECUTION_TIME.str(), Duration.formatNanos((long)executionTime));
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.RESULT_COUNT.str(), resultCount, true);
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.RESULT_SIZE.str(), resultSize, true);
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.PROCESSED_OBJECTS_COUNT.str(), processedObjects, hasWarnings || hasErrors);
        if (hasWarnings) {
            pw.print("\t");
            ResultUtil.printField(pw, Metrics.WARNING_COUNT.str(), warnCount, hasErrors);
        }
        if (hasErrors) {
            pw.print("\t");
            ResultUtil.printField(pw, Metrics.ERROR_COUNT.str(), errorCount, false);
        }
        pw.print("\t}\n");
    }

    private String getOptText(JsonNode node, String fieldName) {
        JsonNode value = node.get(fieldName);
        return value != null ? value.asText() : null;
    }

    private boolean getOptBoolean(JsonNode node, String fieldName, boolean defaultValue) {
        JsonNode value = node.get(fieldName);
        return value != null ? value.asBoolean() : defaultValue;
    }

    private <R, P> Map<String, JsonNode> getOptStatementParameters(R request, Iterator<String> paramNameIter, BiFunction<R, String, P> paramValueAccessor, CheckedFunction<P, JsonNode> paramValueParser) throws IOException {
        HashMap<String, JsonNode> result = null;
        while (paramNameIter.hasNext()) {
            JsonNode stmtParamValue;
            P paramValue;
            String paramName = paramNameIter.next();
            String stmtParamName = QueryServiceServlet.extractStatementParameterName(paramName);
            if (stmtParamName != null) {
                if (result == null) {
                    result = new HashMap<String, JsonNode>();
                }
                paramValue = paramValueAccessor.apply(request, paramName);
                stmtParamValue = paramValueParser.apply(paramValue);
                result.put(stmtParamName, stmtParamValue);
                continue;
            }
            if (!Parameter.ARGS.str().equals(paramName)) continue;
            if (result == null) {
                result = new HashMap();
            }
            if (!(stmtParamValue = paramValueParser.apply(paramValue = paramValueAccessor.apply(request, paramName))).isArray()) continue;
            int ln = stmtParamValue.size();
            for (int i = 0; i < ln; ++i) {
                result.put(String.valueOf(i + 1), stmtParamValue.get(i));
            }
        }
        return result;
    }

    private QueryServiceRequestParameters getRequestParameters(IServletRequest request) throws IOException {
        String contentType = HttpUtil.getContentTypeOnly((IServletRequest)request);
        QueryServiceRequestParameters param = new QueryServiceRequestParameters();
        param.setHost(this.host(request));
        param.setPath(this.servletPath(request));
        if ("application/json".equals(contentType)) {
            try {
                JsonNode jsonRequest = OBJECT_MAPPER.readTree(HttpUtil.getRequestBody((IServletRequest)request));
                String statementParam = Parameter.STATEMENT.str();
                if (jsonRequest.has(statementParam)) {
                    param.setStatement(jsonRequest.get(statementParam).asText());
                }
                param.setFormat(QueryServiceServlet.toLower(this.getOptText(jsonRequest, Parameter.FORMAT.str())));
                param.setPretty(this.getOptBoolean(jsonRequest, Parameter.PRETTY.str(), false));
                param.setMode(QueryServiceServlet.toLower(this.getOptText(jsonRequest, Parameter.MODE.str())));
                param.setClientContextID(this.getOptText(jsonRequest, Parameter.CLIENT_ID.str()));
                param.setTimeout(this.getOptText(jsonRequest, Parameter.TIMEOUT.str()));
                param.setMaxResultReads(this.getOptText(jsonRequest, Parameter.MAX_RESULT_READS.str()));
                param.setPlanFormat(this.getOptText(jsonRequest, Parameter.PLAN_FORMAT.str()));
                param.setExpressionTree(this.getOptBoolean(jsonRequest, Parameter.EXPRESSION_TREE.str(), false));
                param.setRewrittenExpressionTree(this.getOptBoolean(jsonRequest, Parameter.REWRITTEN_EXPRESSION_TREE.str(), false));
                param.setLogicalPlan(this.getOptBoolean(jsonRequest, Parameter.LOGICAL_PLAN.str(), false));
                param.setOptimizedLogicalPlan(this.getOptBoolean(jsonRequest, Parameter.OPTIMIZED_LOGICAL_PLAN.str(), false));
                param.setJob(this.getOptBoolean(jsonRequest, Parameter.JOB.str(), false));
                param.setSignature(this.getOptBoolean(jsonRequest, Parameter.SIGNATURE.str(), true));
                param.setStatementParams(this.getOptStatementParameters(jsonRequest, jsonRequest.fieldNames(), JsonNode::get, v -> v));
                param.setMultiStatement(this.getOptBoolean(jsonRequest, Parameter.MULTI_STATEMENT.str(), true));
            }
            catch (JsonParseException | JsonMappingException e) {
                GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, e.getMessage(), e);
            }
        } else {
            param.setStatement(request.getParameter((CharSequence)Parameter.STATEMENT.str()));
            if (param.getStatement() == null) {
                param.setStatement(HttpUtil.getRequestBody((IServletRequest)request));
            }
            param.setFormat(QueryServiceServlet.toLower(request.getParameter((CharSequence)Parameter.FORMAT.str())));
            param.setPretty(Boolean.parseBoolean(request.getParameter((CharSequence)Parameter.PRETTY.str())));
            param.setMode(QueryServiceServlet.toLower(request.getParameter((CharSequence)Parameter.MODE.str())));
            param.setClientContextID(request.getParameter((CharSequence)Parameter.CLIENT_ID.str()));
            param.setTimeout(request.getParameter((CharSequence)Parameter.TIMEOUT.str()));
            param.setMaxResultReads(request.getParameter((CharSequence)Parameter.MAX_RESULT_READS.str()));
            param.setPlanFormat(request.getParameter((CharSequence)Parameter.PLAN_FORMAT.str()));
            String multiStatementParam = request.getParameter((CharSequence)Parameter.MULTI_STATEMENT.str());
            param.setMultiStatement(multiStatementParam == null || Boolean.parseBoolean(multiStatementParam));
            try {
                param.setStatementParams(this.getOptStatementParameters(request, request.getParameterNames().iterator(), IServletRequest::getParameter, arg_0 -> ((ObjectMapper)OBJECT_MAPPER).readTree(arg_0)));
            }
            catch (JsonParseException | JsonMappingException e) {
                GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, e.getMessage(), e);
            }
        }
        return param;
    }

    private static IStatementExecutor.ResultDelivery parseResultDelivery(String mode) {
        if ("async".equals(mode)) {
            return IStatementExecutor.ResultDelivery.ASYNC;
        }
        if ("deferred".equals(mode)) {
            return IStatementExecutor.ResultDelivery.DEFERRED;
        }
        return IStatementExecutor.ResultDelivery.IMMEDIATE;
    }

    private static String handlePath(IStatementExecutor.ResultDelivery delivery) {
        switch (delivery) {
            case ASYNC: {
                return "/status/";
            }
            case DEFERRED: {
                return "/result/";
            }
        }
        return "";
    }

    protected String getHandleUrl(String host, String path, IStatementExecutor.ResultDelivery delivery) {
        return "http://" + host + path + QueryServiceServlet.handlePath(delivery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(IServletRequest request, IServletResponse response) throws IOException {
        QueryServiceRequestParameters param = this.getRequestParameters(request);
        LOGGER.info("handleRequest: {}", (Object)param);
        long elapsedStart = System.nanoTime();
        PrintWriter httpWriter = response.writer();
        IStatementExecutor.ResultDelivery delivery = QueryServiceServlet.parseResultDelivery(param.getMode());
        ResultProperties resultProperties = param.getMaxResultReads() == null ? new ResultProperties(delivery) : new ResultProperties(delivery, Long.parseLong(param.getMaxResultReads()));
        String handleUrl = this.getHandleUrl(param.getHost(), param.getPath(), delivery);
        SessionOutput sessionOutput = QueryServiceServlet.createSessionOutput(param, handleUrl, httpWriter);
        SessionConfig sessionConfig = sessionOutput.config();
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
        IStatementExecutor.Stats stats = new IStatementExecutor.Stats();
        RequestExecutionState execution = new RequestExecutionState();
        sessionOutput.hold();
        sessionOutput.out().print("{\n");
        QueryServiceServlet.printRequestId(sessionOutput.out());
        QueryServiceServlet.printClientContextID(sessionOutput.out(), param);
        QueryServiceServlet.printSignature(sessionOutput.out(), param);
        QueryServiceServlet.printType(sessionOutput.out(), sessionConfig);
        long errorCount = 1L;
        List<ExecutionWarning> warnings = Collections.emptyList();
        try {
            if (param.getStatement() == null || param.getStatement().isEmpty()) {
                throw new RuntimeDataException(40, new Serializable[0]);
            }
            String statementsText = param.getStatement() + ";";
            Map<String, String> optionalParams = null;
            if (this.optionalParamProvider != null) {
                optionalParams = this.optionalParamProvider.apply(request);
            }
            Map<String, byte[]> statementParams = RequestParameters.serializeParameterValues(param.getStatementParams());
            if (request.getHeader((CharSequence)"Origin") != null) {
                response.setHeader((CharSequence)"Access-Control-Allow-Origin", (Object)request.getHeader((CharSequence)"Origin"));
            }
            response.setHeader((CharSequence)"Access-Control-Allow-Headers", (Object)"Origin, X-Requested-With, Content-Type, Accept");
            response.setStatus(execution.getHttpStatus());
            this.executeStatement(statementsText, sessionOutput, resultProperties, stats, param, execution, optionalParams, statementParams);
            if (IStatementExecutor.ResultDelivery.IMMEDIATE == delivery || IStatementExecutor.ResultDelivery.DEFERRED == delivery) {
                ResultUtil.printStatus(sessionOutput, execution.getResultStatus());
            }
            if (!warnings.isEmpty()) {
                this.printWarnings(sessionOutput.out(), warnings);
            }
            errorCount = 0L;
        }
        catch (Exception | org.apache.asterix.aqlplus.parser.TokenMgrError | TokenMgrError e) {
            this.handleExecuteStatementException(e, execution, param);
            response.setStatus(execution.getHttpStatus());
            this.printError(sessionOutput.out(), e);
            ResultUtil.printStatus(sessionOutput, execution.getResultStatus());
        }
        finally {
            sessionOutput.release();
            execution.finish();
        }
        QueryServiceServlet.printMetrics(sessionOutput.out(), System.nanoTime() - elapsedStart, execution.duration(), stats.getCount(), stats.getSize(), stats.getProcessedObjects(), errorCount, warnings.size());
        sessionOutput.out().print("}\n");
        sessionOutput.out().flush();
        if (sessionOutput.out().checkError()) {
            LOGGER.warn("Error flushing output writer");
        }
    }

    protected void executeStatement(String statementsText, SessionOutput sessionOutput, ResultProperties resultProperties, IStatementExecutor.Stats stats, QueryServiceRequestParameters param, RequestExecutionState execution, Map<String, String> optionalParameters, Map<String, byte[]> statementParameters) throws Exception {
        IClusterManagementWork.ClusterState clusterState = ((ICcApplicationContext)this.appCtx).getClusterStateManager().getState();
        if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
            throw new IllegalStateException("Cannot execute request, cluster is " + clusterState);
        }
        IParser parser = this.compilationProvider.getParserFactory().createParser(statementsText);
        List statements = parser.parse();
        MetadataManager.INSTANCE.init();
        IStatementExecutor translator = this.statementExecutorFactory.create((ICcApplicationContext)this.appCtx, statements, sessionOutput, this.compilationProvider, this.componentProvider);
        execution.start();
        Map<String, IAObject> stmtParams = RequestParameters.deserializeParameterValues(statementParameters);
        RequestParameters requestParameters = new RequestParameters(this.getResultSet(), resultProperties, stats, null, param.getClientContextID(), optionalParameters, stmtParams, param.isMultiStatement());
        translator.compileAndExecute(this.getHyracksClientConnection(), this.queryCtx, (IRequestParameters)requestParameters);
        execution.end();
        this.printExecutionPlans(sessionOutput, translator.getExecutionPlans());
    }

    protected void handleExecuteStatementException(Throwable t, RequestExecutionState state, QueryServiceRequestParameters param) {
        if (t instanceof org.apache.asterix.aqlplus.parser.TokenMgrError || t instanceof TokenMgrError || t instanceof AlgebricksException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("handleException: {}: {}", (Object)t.getMessage(), (Object)param, (Object)t);
            } else {
                LOGGER.info("handleException: {}: {}", (Object)t.getMessage(), (Object)param);
            }
            state.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.BAD_REQUEST);
        } else if (t instanceof HyracksException) {
            HyracksException he = (HyracksException)t;
            switch (he.getComponent() + he.getErrorCode()) {
                case "ASX30": {
                    LOGGER.info("handleException: request execution timed out: {}", (Object)param);
                    state.setStatus(AbstractQueryApiServlet.ResultStatus.TIMEOUT, HttpResponseStatus.OK);
                    break;
                }
                case "ASX32": 
                case "ASX33": {
                    LOGGER.warn("handleException: {}: {}", (Object)he.getMessage(), (Object)param);
                    state.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.SERVICE_UNAVAILABLE);
                    break;
                }
                case "ASX40": {
                    state.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.BAD_REQUEST);
                    break;
                }
                default: {
                    LOGGER.warn("handleException: unexpected exception {}: {}", (Object)he.getMessage(), (Object)param, (Object)he);
                    state.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    break;
                }
            }
        } else {
            LOGGER.warn("handleException: unexpected exception: {}", (Object)param, (Object)t);
            state.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected void printError(PrintWriter sessionOut, Throwable throwable) {
        ResultUtil.printError(sessionOut, throwable);
    }

    protected void printWarnings(PrintWriter pw, List<ExecutionWarning> warnings) {
        ResultUtil.printWarnings(pw, warnings);
    }

    protected void printExecutionPlans(SessionOutput output, ExecutionPlans executionPlans) {
        PrintWriter pw = output.out();
        pw.print("\t\"");
        pw.print(AbstractQueryApiServlet.ResultFields.PLANS.str());
        pw.print("\":");
        SessionConfig.PlanFormat planFormat = output.config().getPlanFormat();
        switch (planFormat) {
            case JSON: 
            case STRING: {
                pw.print(ExecutionPlansJsonPrintUtil.asJson((ExecutionPlans)executionPlans, (SessionConfig.PlanFormat)planFormat));
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized plan format: " + planFormat);
            }
        }
        pw.print(",\n");
    }

    private static boolean isJsonFormat(String format) {
        return format.startsWith("application/json") || format.equalsIgnoreCase("json");
    }

    public static String extractStatementParameterName(String name) {
        int ln = name.length();
        if (ln > 1 && name.charAt(0) == '$' && Character.isLetter(name.charAt(1)) && (ln == 2 || QueryServiceServlet.isStatementParameterNameRest(name, 2))) {
            return name.substring(1);
        }
        return null;
    }

    private static boolean isStatementParameterNameRest(CharSequence input, int startIndex) {
        int i;
        int ln = input.length();
        for (i = startIndex; i < ln; ++i) {
            boolean ok;
            char c = input.charAt(i);
            boolean bl = ok = c == '_' || Character.isLetterOrDigit(c);
            if (ok) continue;
            return false;
        }
        return i > startIndex;
    }

    @FunctionalInterface
    static interface CheckedFunction<I, O> {
        public O apply(I var1) throws IOException;
    }

    protected static final class RequestExecutionState {
        private long execStart = -1L;
        private long execEnd = -1L;
        private AbstractQueryApiServlet.ResultStatus resultStatus = AbstractQueryApiServlet.ResultStatus.SUCCESS;
        private HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;

        protected RequestExecutionState() {
        }

        void setStatus(AbstractQueryApiServlet.ResultStatus resultStatus, HttpResponseStatus httpResponseStatus) {
            this.resultStatus = resultStatus;
            this.httpResponseStatus = httpResponseStatus;
        }

        AbstractQueryApiServlet.ResultStatus getResultStatus() {
            return this.resultStatus;
        }

        HttpResponseStatus getHttpStatus() {
            return this.httpResponseStatus;
        }

        void start() {
            this.execStart = System.nanoTime();
        }

        void end() {
            this.execEnd = System.nanoTime();
        }

        void finish() {
            if (this.execStart == -1L) {
                this.execEnd = -1L;
            } else if (this.execEnd == -1L) {
                this.execEnd = System.nanoTime();
            }
        }

        long duration() {
            return this.execEnd - this.execStart;
        }
    }

    private static enum Metrics {
        ELAPSED_TIME("elapsedTime"),
        EXECUTION_TIME("executionTime"),
        RESULT_COUNT("resultCount"),
        RESULT_SIZE("resultSize"),
        ERROR_COUNT("errorCount"),
        PROCESSED_OBJECTS_COUNT("processedObjects"),
        WARNING_COUNT("warningCount");

        private final String str;

        private Metrics(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    private static enum Attribute {
        HEADER("header"),
        LOSSLESS("lossless");

        private final String str;

        private Attribute(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    public static enum Parameter {
        ARGS("args"),
        STATEMENT("statement"),
        FORMAT("format"),
        CLIENT_ID("client_context_id"),
        PRETTY("pretty"),
        MODE("mode"),
        TIMEOUT("timeout"),
        PLAN_FORMAT("plan-format"),
        MAX_RESULT_READS("max-result-reads"),
        EXPRESSION_TREE("expression-tree"),
        REWRITTEN_EXPRESSION_TREE("rewritten-expression-tree"),
        LOGICAL_PLAN("logical-plan"),
        OPTIMIZED_LOGICAL_PLAN("optimized-logical-plan"),
        JOB("job"),
        SIGNATURE("signature"),
        MULTI_STATEMENT("multi-statement");

        private final String str;

        private Parameter(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }
}

