/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.asterix.api.http.server.QueryServiceServlet;
import org.apache.hyracks.util.JSONUtil;

public class QueryServiceRequestParameters {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String host;
    private String path;
    private String statement;
    private String format;
    private String timeout;
    private boolean pretty;
    private String clientContextID;
    private String mode;
    private String maxResultReads;
    private String planFormat;
    private Map<String, JsonNode> statementParams;
    private boolean expressionTree;
    private boolean rewrittenExpressionTree;
    private boolean logicalPlan;
    private boolean optimizedLogicalPlan;
    private boolean job;
    private boolean signature;
    private boolean multiStatement;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public String getClientContextID() {
        return this.clientContextID;
    }

    public void setClientContextID(String clientContextID) {
        this.clientContextID = clientContextID;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMaxResultReads() {
        return this.maxResultReads;
    }

    public void setMaxResultReads(String maxResultReads) {
        this.maxResultReads = maxResultReads;
    }

    public String getPlanFormat() {
        return this.planFormat;
    }

    public void setPlanFormat(String planFormat) {
        this.planFormat = planFormat;
    }

    public Map<String, JsonNode> getStatementParams() {
        return this.statementParams;
    }

    public void setStatementParams(Map<String, JsonNode> statementParams) {
        this.statementParams = statementParams;
    }

    public boolean isExpressionTree() {
        return this.expressionTree;
    }

    public void setExpressionTree(boolean expressionTree) {
        this.expressionTree = expressionTree;
    }

    public boolean isRewrittenExpressionTree() {
        return this.rewrittenExpressionTree;
    }

    public void setRewrittenExpressionTree(boolean rewrittenExpressionTree) {
        this.rewrittenExpressionTree = rewrittenExpressionTree;
    }

    public boolean isLogicalPlan() {
        return this.logicalPlan;
    }

    public void setLogicalPlan(boolean logicalPlan) {
        this.logicalPlan = logicalPlan;
    }

    public boolean isOptimizedLogicalPlan() {
        return this.optimizedLogicalPlan;
    }

    public void setOptimizedLogicalPlan(boolean optimizedLogicalPlan) {
        this.optimizedLogicalPlan = optimizedLogicalPlan;
    }

    public boolean isJob() {
        return this.job;
    }

    public void setJob(boolean job) {
        this.job = job;
    }

    public boolean isSignature() {
        return this.signature;
    }

    public void setSignature(boolean signature) {
        this.signature = signature;
    }

    public boolean isMultiStatement() {
        return this.multiStatement;
    }

    public void setMultiStatement(boolean multiStatement) {
        this.multiStatement = multiStatement;
    }

    public String toString() {
        try {
            ObjectNode on = OBJECT_MAPPER.createObjectNode();
            on.put("host", this.host);
            on.put("path", this.path);
            on.put("statement", this.statement != null ? JSONUtil.escape((StringBuilder)new StringBuilder(), (String)this.statement).toString() : null);
            on.put("pretty", this.pretty);
            on.put("mode", this.mode);
            on.put("clientContextID", this.clientContextID);
            on.put("format", this.format);
            on.put("timeout", this.timeout);
            on.put("maxResultReads", this.maxResultReads);
            on.put("planFormat", this.planFormat);
            on.put("expressionTree", this.expressionTree);
            on.put("rewrittenExpressionTree", this.rewrittenExpressionTree);
            on.put("logicalPlan", this.logicalPlan);
            on.put("optimizedLogicalPlan", this.optimizedLogicalPlan);
            on.put("job", this.job);
            on.put("signature", this.signature);
            on.put("multiStatement", this.multiStatement);
            if (this.statementParams != null) {
                for (Map.Entry<String, JsonNode> statementParam : this.statementParams.entrySet()) {
                    on.set('$' + statementParam.getKey(), statementParam.getValue());
                }
            }
            return OBJECT_MAPPER.writeValueAsString((Object)on);
        }
        catch (JsonProcessingException e) {
            QueryServiceServlet.LOGGER.debug("unexpected exception marshalling {} instance to json", this.getClass(), (Object)e);
            return e.toString();
        }
    }
}

