/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.Serializable;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class HyracksDataException
extends HyracksException {
    private static final long serialVersionUID = 1L;

    public static HyracksDataException create(Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("Attempt to wrap null in a HyracksDataException");
        }
        if (cause instanceof HyracksDataException) {
            return (HyracksDataException)cause;
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return new HyracksDataException(cause);
    }

    public static HyracksDataException create(int code, SourceLocation sourceLoc, Serializable ... params) {
        return new HyracksDataException("HYR", code, ErrorCode.getErrorMessage(code), null, sourceLoc, params);
    }

    public static HyracksDataException create(int code, Serializable ... params) {
        return new HyracksDataException("HYR", code, ErrorCode.getErrorMessage(code), params);
    }

    public static HyracksDataException create(int code, Throwable cause, SourceLocation sourceLoc, Serializable ... params) {
        return new HyracksDataException("HYR", code, ErrorCode.getErrorMessage(code), cause, sourceLoc, params);
    }

    public static HyracksDataException create(int code, Throwable cause, Serializable ... params) {
        return new HyracksDataException("HYR", code, ErrorCode.getErrorMessage(code), cause, params);
    }

    public HyracksDataException(String component, int errorCode, String message, Throwable cause, String nodeId, Serializable ... params) {
        super(component, errorCode, message, cause, nodeId, params);
    }

    public HyracksDataException(String component, int errorCode, String message, Throwable cause, String nodeId, StackTraceElement[] stackTrace, Serializable ... params) {
        super(component, errorCode, message, cause, nodeId, params);
        this.setStackTrace(stackTrace);
    }

    @Deprecated
    public HyracksDataException(String message) {
        super(message);
    }

    protected HyracksDataException(Throwable cause) {
        super(cause);
    }

    @Deprecated
    public HyracksDataException(String message, Throwable cause) {
        super(message, cause);
    }

    public HyracksDataException(String component, int errorCode, Serializable ... params) {
        super(component, errorCode, (String)null, (Throwable)null, (String)null, params);
    }

    public HyracksDataException(Throwable cause, int errorCode, Serializable ... params) {
        super("", errorCode, cause.getMessage(), cause, (String)null, params);
    }

    public HyracksDataException(String component, int errorCode, String message, Serializable ... params) {
        super(component, errorCode, message, (Throwable)null, (String)null, params);
    }

    public HyracksDataException(String component, int errorCode, Throwable cause, Serializable ... params) {
        super(component, errorCode, cause, params);
    }

    public HyracksDataException(String component, int errorCode, String message, Throwable cause, Serializable ... params) {
        super(component, errorCode, message, cause, (String)null, params);
    }

    public HyracksDataException(String component, int errorCode, String message, Throwable cause, SourceLocation sourceLoc, Serializable ... params) {
        super(component, errorCode, message, cause, sourceLoc, null, params);
    }

    public static HyracksDataException create(HyracksDataException e, String nodeId) {
        return new HyracksDataException(e.getComponent(), e.getErrorCode(), e.getMessage(), e.getCause(), nodeId, e.getStackTrace(), new Serializable[]{e.getParams()});
    }
}

