/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.JSONDataParser;
import org.apache.asterix.external.parser.factory.AbstractRecordStreamParserFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class JSONDataParserFactory
extends AbstractRecordStreamParserFactory<char[]> {
    private static final long serialVersionUID = 1L;
    private static final List<String> PARSER_FORMAT = Collections.unmodifiableList(Arrays.asList("json"));
    private static final List<ATypeTag> UNSUPPORTED_TYPES = Collections.unmodifiableList(Arrays.asList(ATypeTag.MULTISET, ATypeTag.POINT3D, ATypeTag.CIRCLE, ATypeTag.RECTANGLE, ATypeTag.INTERVAL, ATypeTag.DAYTIMEDURATION, ATypeTag.DURATION, ATypeTag.BINARY));
    private final JsonFactory jsonFactory = new JsonFactory();

    public JSONDataParserFactory() {
        this.jsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        this.jsonFactory.configure(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES, true);
        this.jsonFactory.configure(JsonFactory.Feature.INTERN_FIELD_NAMES, true);
    }

    @Override
    public IStreamDataParser createInputStreamParser(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return this.createParser();
    }

    @Override
    public void setMetaType(ARecordType metaType) {
    }

    @Override
    public List<String> getParserFormats() {
        return PARSER_FORMAT;
    }

    @Override
    public IRecordDataParser<char[]> createRecordParser(IHyracksTaskContext ctx) throws HyracksDataException {
        return this.createParser();
    }

    @Override
    public Class<?> getRecordClass() {
        return char[].class;
    }

    private JSONDataParser createParser() throws HyracksDataException {
        return new JSONDataParser(this.recordType, this.jsonFactory);
    }

    @Override
    public void setRecordType(ARecordType recordType) throws AsterixException {
        this.checkRecordTypeCompatibility(recordType);
        super.setRecordType(recordType);
    }

    private void checkRecordTypeCompatibility(ARecordType recordType) throws AsterixException {
        IAType[] fieldTypes;
        for (IAType type : fieldTypes = recordType.getFieldTypes()) {
            this.checkTypeCompatibility(type);
        }
    }

    private void checkTypeCompatibility(IAType type) throws AsterixException {
        if (UNSUPPORTED_TYPES.contains(type.getTypeTag())) {
            throw new AsterixException(4, new Serializable[]{JSONDataParserFactory.class.getName(), type.getTypeTag().toString()});
        }
        if (type.getTypeTag() == ATypeTag.ARRAY) {
            this.checkTypeCompatibility(((AOrderedListType)type).getItemType());
        } else if (type.getTypeTag() == ATypeTag.OBJECT) {
            this.checkRecordTypeCompatibility((ARecordType)type);
        } else if (type.getTypeTag() == ATypeTag.UNION) {
            this.checkTypeCompatibility(((AUnionType)type).getActualType());
        }
    }
}

