/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream.factory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.input.stream.SocketClientInputStream;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SocketClientInputStreamFactory
implements IInputStreamFactory {
    private static final long serialVersionUID = 1L;
    private transient IServiceContext serviceCtx;
    private transient AlgebricksAbsolutePartitionConstraint clusterLocations;
    private List<Pair<String, Integer>> sockets;

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        this.clusterLocations = IExternalDataSourceFactory.getPartitionConstraints((ICcApplicationContext)this.serviceCtx.getApplicationContext(), this.clusterLocations, this.sockets.size());
        return this.clusterLocations;
    }

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration) throws AsterixException {
        try {
            String[] socketsArray;
            this.serviceCtx = serviceCtx;
            this.sockets = new ArrayList<Pair<String, Integer>>();
            String socketsValue = configuration.get("sockets");
            if (socketsValue == null) {
                throw new IllegalArgumentException("'sockets' parameter not specified as part of adapter configuration");
            }
            for (String socket : socketsArray = socketsValue.split(",")) {
                String[] socketTokens = socket.split(":");
                String host = socketTokens[0].trim();
                int port = Integer.parseInt(socketTokens[1].trim());
                InetAddress[] resolved = SystemDefaultDnsResolver.INSTANCE.resolve(host);
                Pair p = new Pair((Object)resolved[0].getHostAddress(), (Object)port);
                this.sockets.add((Pair<String, Integer>)p);
            }
        }
        catch (UnknownHostException e) {
            throw new AsterixException((Throwable)e);
        }
    }

    @Override
    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            return new SocketClientInputStream(this.sockets.get(partition));
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

