/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IExternalIndexer;
import org.apache.asterix.external.api.IIndexibleExternalDataSource;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingScheduler;
import org.apache.asterix.external.input.record.reader.IndexingStreamRecordReader;
import org.apache.asterix.external.input.record.reader.hdfs.HDFSRecordReader;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.asterix.external.input.stream.HDFSInputStream;
import org.apache.asterix.external.provider.ExternalIndexerProvider;
import org.apache.asterix.external.provider.StreamRecordReaderProvider;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.hdfs.dataflow.ConfFactory;
import org.apache.hyracks.hdfs.dataflow.InputSplitsFactory;
import org.apache.hyracks.hdfs.scheduler.Scheduler;

public class HDFSDataSourceFactory
implements IRecordReaderFactory<Object>,
IIndexibleExternalDataSource {
    protected static final long serialVersionUID = 1L;
    protected transient AlgebricksAbsolutePartitionConstraint clusterLocations;
    protected transient IServiceContext serviceCtx;
    protected String[] readSchedule;
    protected boolean[] read;
    protected InputSplitsFactory inputSplitsFactory;
    protected ConfFactory confFactory;
    protected boolean configured = false;
    protected static Scheduler hdfsScheduler;
    protected static IndexingScheduler indexingScheduler;
    protected static Boolean initialized;
    protected static Object initLock;
    protected List<ExternalFile> files;
    protected Map<String, String> configuration;
    protected Class<?> recordClass;
    protected boolean indexingOp = false;
    private JobConf conf;
    private InputSplit[] inputSplits;
    private String nodeName;
    private Class recordReaderClazz;
    private static final List<String> recordReaderNames;

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration) throws AsterixException {
        try {
            this.serviceCtx = serviceCtx;
            this.configuration = configuration;
            HDFSDataSourceFactory.init((ICCServiceContext)serviceCtx);
            JobConf conf = HDFSUtils.configureHDFSJobConf(configuration);
            this.confFactory = new ConfFactory(conf);
            this.clusterLocations = this.getPartitionConstraint();
            int numPartitions = this.clusterLocations.getLocations().length;
            InputSplit[] inputSplits = this.files == null ? conf.getInputFormat().getSplits(conf, numPartitions) : HDFSUtils.getSplits(conf, this.files);
            this.readSchedule = this.indexingOp ? indexingScheduler.getLocationConstraints(inputSplits) : hdfsScheduler.getLocationConstraints(inputSplits);
            this.inputSplitsFactory = new InputSplitsFactory(inputSplits);
            this.read = new boolean[this.readSchedule.length];
            Arrays.fill(this.read, false);
            String formatString = configuration.get("format");
            if (formatString == null || formatString.equals("hdfs-writable")) {
                RecordReader reader = conf.getInputFormat().getRecordReader(inputSplits[0], conf, Reporter.NULL);
                this.recordClass = reader.createValue().getClass();
                reader.close();
            } else {
                this.recordReaderClazz = StreamRecordReaderProvider.getRecordReaderClazz(configuration);
                this.recordClass = char[].class;
            }
        }
        catch (IOException e) {
            throw new AsterixException((Throwable)e);
        }
    }

    @Override
    public void setSnapshot(List<ExternalFile> files, boolean indexingOp) {
        this.files = files;
        this.indexingOp = indexingOp;
    }

    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition, IExternalIndexer indexer) throws HyracksDataException {
        try {
            this.restoreConfig(ctx);
            return new HDFSInputStream(this.read, this.inputSplits, this.readSchedule, this.nodeName, this.conf, this.configuration, this.files, indexer);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void restoreConfig(IHyracksTaskContext ctx) throws HyracksDataException {
        if (!this.configured) {
            this.conf = this.confFactory.getConf();
            this.inputSplits = this.inputSplitsFactory.getSplits();
            this.nodeName = ctx.getJobletContext().getServiceContext().getNodeId();
            this.configured = true;
        }
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        this.clusterLocations = HDFSUtils.getPartitionConstraints((IApplicationContext)this.serviceCtx.getApplicationContext(), this.clusterLocations);
        return this.clusterLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(ICCServiceContext serviceCtx) throws HyracksDataException {
        if (!initialized.booleanValue()) {
            Object object = initLock;
            synchronized (object) {
                if (!initialized.booleanValue()) {
                    hdfsScheduler = HDFSUtils.initializeHDFSScheduler(serviceCtx);
                    indexingScheduler = HDFSUtils.initializeIndexingHDFSScheduler(serviceCtx);
                    initialized = true;
                }
            }
        }
    }

    public JobConf getJobConf() throws HyracksDataException {
        return this.confFactory.getConf();
    }

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return ExternalDataUtils.getDataSourceType(this.configuration);
    }

    @Override
    public IRecordReader<? extends Object> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            IExternalIndexer indexer;
            IExternalIndexer iExternalIndexer = indexer = this.files == null ? null : ExternalIndexerProvider.getIndexer(this.configuration);
            if (this.recordReaderClazz != null) {
                StreamRecordReader streamReader = (StreamRecordReader)this.recordReaderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                streamReader.configure(this.createInputStream(ctx, partition, indexer), this.configuration);
                if (indexer != null) {
                    return new IndexingStreamRecordReader(streamReader, indexer);
                }
                return streamReader;
            }
            this.restoreConfig(ctx);
            return new HDFSRecordReader(this.read, this.inputSplits, this.readSchedule, this.nodeName, this.conf, this.files, indexer);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public Class<?> getRecordClass() {
        return this.recordClass;
    }

    @Override
    public boolean isIndexible() {
        return true;
    }

    @Override
    public boolean isIndexingOp() {
        return this.files != null && this.indexingOp;
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    static {
        initialized = false;
        initLock = new Object();
        recordReaderNames = Collections.unmodifiableList(Arrays.asList("hdfs"));
    }
}

