/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.dataflow;

import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.IExceptionHandler;
import org.apache.asterix.external.util.FeedFrameUtil;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeedExceptionHandler
implements IExceptionHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IHyracksTaskContext ctx;
    private final FrameTupleAccessor fta;

    public FeedExceptionHandler(IHyracksTaskContext ctx, FrameTupleAccessor fta) {
        this.ctx = ctx;
        this.fta = fta;
    }

    public ByteBuffer handle(HyracksDataException th, ByteBuffer frame) {
        try {
            if (th.getErrorCode() == 2) {
                int tupleIndex;
                block6: {
                    this.fta.reset(frame);
                    tupleIndex = (Integer)th.getParams()[0];
                    try {
                        this.logExceptionCausingTuple(tupleIndex, (Throwable)th);
                    }
                    catch (Exception ex) {
                        ex.addSuppressed((Throwable)th);
                        if (!LOGGER.isWarnEnabled()) break block6;
                        LOGGER.warn("Unable to log exception causing tuple due to..." + ex.getMessage());
                    }
                }
                return FeedFrameUtil.removeBadTuple(this.ctx, tupleIndex, this.fta);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unable to handle exception " + exception.getMessage());
            }
            return null;
        }
    }

    private void logExceptionCausingTuple(int tupleIndex, Throwable e) throws HyracksDataException {
        LOGGER.log(Level.WARN, e.getMessage(), e);
    }
}

