/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.io.DataOutput;
import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFieldFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class StreamSelectRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory cond;
    private final IBinaryBooleanInspectorFactory binaryBooleanInspectorFactory;
    private final IMissingWriterFactory missingWriterFactory;
    private boolean retainMissing;
    private int missingPlaceholderVariableIndex;

    public StreamSelectRuntimeFactory(IScalarEvaluatorFactory cond, int[] projectionList, IBinaryBooleanInspectorFactory binaryBooleanInspectorFactory, boolean retainMissing, int missingPlaceholderVariableIndex, IMissingWriterFactory missingWriterFactory) {
        super(projectionList);
        this.cond = cond;
        this.binaryBooleanInspectorFactory = binaryBooleanInspectorFactory;
        this.retainMissing = retainMissing;
        this.missingPlaceholderVariableIndex = missingPlaceholderVariableIndex;
        this.missingWriterFactory = missingWriterFactory;
    }

    public void retainMissing(boolean retainMissing, int index) {
        this.retainMissing = retainMissing;
        this.missingPlaceholderVariableIndex = index;
    }

    public String toString() {
        return "stream-select " + this.cond.toString();
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) {
        final IBinaryBooleanInspector bbi = this.binaryBooleanInspectorFactory.createBinaryBooleanInspector(ctx);
        return new AbstractOneInputOneOutputOneFieldFramePushRuntime(){
            private IPointable p = VoidPointable.FACTORY.createPointable();
            private IScalarEvaluator eval;
            private IMissingWriter missingWriter = null;
            private ArrayTupleBuilder missingTupleBuilder = null;

            @Override
            public void open() throws HyracksDataException {
                if (this.eval == null) {
                    this.initAccessAppendFieldRef(ctx);
                    this.eval = StreamSelectRuntimeFactory.this.cond.createScalarEvaluator(ctx);
                }
                super.open();
                if (StreamSelectRuntimeFactory.this.retainMissing && this.missingWriter == null) {
                    this.missingWriter = StreamSelectRuntimeFactory.this.missingWriterFactory.createMissingWriter();
                    this.missingTupleBuilder = new ArrayTupleBuilder(1);
                    DataOutput out = this.missingTupleBuilder.getDataOutput();
                    this.missingWriter.writeMissing(out);
                    this.missingTupleBuilder.addFieldEndOffset();
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    this.eval.evaluate((IFrameTupleReference)this.tRef, this.p);
                    if (bbi.getBooleanValue(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength())) {
                        if (StreamSelectRuntimeFactory.this.projectionList != null) {
                            this.appendProjectionToFrame(t, StreamSelectRuntimeFactory.this.projectionList);
                            continue;
                        }
                        this.appendTupleToFrame(t);
                        continue;
                    }
                    if (!StreamSelectRuntimeFactory.this.retainMissing) continue;
                    for (int i = 0; i < this.tRef.getFieldCount(); ++i) {
                        if (i == StreamSelectRuntimeFactory.this.missingPlaceholderVariableIndex) {
                            this.appendField(this.missingTupleBuilder.getByteArray(), 0, this.missingTupleBuilder.getSize());
                            continue;
                        }
                        this.appendField((IFrameTupleAccessor)this.tAccess, t, i);
                    }
                }
            }

            public void flush() throws HyracksDataException {
                this.appender.flush(this.writer);
            }
        };
    }
}

