/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspector;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspectorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class StreamLimitRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory maxObjectsEvalFactory;
    private final IScalarEvaluatorFactory offsetEvalFactory;
    private final IBinaryIntegerInspectorFactory binaryIntegerInspectorFactory;

    public StreamLimitRuntimeFactory(IScalarEvaluatorFactory maxObjectsEvalFactory, IScalarEvaluatorFactory offsetEvalFactory, int[] projectionList, IBinaryIntegerInspectorFactory binaryIntegerInspectorFactory) {
        super(projectionList);
        this.maxObjectsEvalFactory = maxObjectsEvalFactory;
        this.offsetEvalFactory = offsetEvalFactory;
        this.binaryIntegerInspectorFactory = binaryIntegerInspectorFactory;
    }

    public String toString() {
        String s = "stream-limit " + this.maxObjectsEvalFactory.toString();
        if (this.offsetEvalFactory != null) {
            return s + ", " + this.offsetEvalFactory.toString();
        }
        return s;
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) {
        final IBinaryIntegerInspector bii = this.binaryIntegerInspectorFactory.createBinaryIntegerInspector(ctx);
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private final IPointable p = VoidPointable.FACTORY.createPointable();
            private IScalarEvaluator evalMaxObjects;
            private IScalarEvaluator evalOffset = null;
            private int toWrite = 0;
            private int toSkip = 0;
            private boolean firstTuple = true;
            private boolean afterLastTuple = false;

            @Override
            public void open() throws HyracksDataException {
                super.open();
                if (this.evalMaxObjects == null) {
                    this.initAccessAppendRef(ctx);
                    this.evalMaxObjects = StreamLimitRuntimeFactory.this.maxObjectsEvalFactory.createScalarEvaluator(ctx);
                    if (StreamLimitRuntimeFactory.this.offsetEvalFactory != null) {
                        this.evalOffset = StreamLimitRuntimeFactory.this.offsetEvalFactory.createScalarEvaluator(ctx);
                    }
                }
                this.afterLastTuple = false;
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                if (this.afterLastTuple) {
                    return;
                }
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                int start = 0;
                if (nTuple <= this.toSkip) {
                    this.toSkip -= nTuple;
                    return;
                }
                if (this.toSkip > 0) {
                    start = this.toSkip;
                    this.toSkip = 0;
                }
                for (int t = start; t < nTuple; ++t) {
                    if (this.firstTuple) {
                        this.firstTuple = false;
                        this.toWrite = this.evaluateInteger(this.evalMaxObjects, t);
                        if (this.evalOffset != null) {
                            this.toSkip = this.evaluateInteger(this.evalOffset, t);
                        }
                    }
                    if (this.toSkip > 0) {
                        --this.toSkip;
                        continue;
                    }
                    if (this.toWrite > 0) {
                        --this.toWrite;
                        if (StreamLimitRuntimeFactory.this.projectionList != null) {
                            this.appendProjectionToFrame(t, StreamLimitRuntimeFactory.this.projectionList);
                            continue;
                        }
                        this.appendTupleToFrame(t);
                        continue;
                    }
                    this.afterLastTuple = true;
                    break;
                }
            }

            @Override
            public void close() throws HyracksDataException {
                this.toWrite = 0;
                this.toSkip = 0;
                this.firstTuple = true;
                this.afterLastTuple = false;
                super.close();
            }

            private int evaluateInteger(IScalarEvaluator eval, int tIdx) throws HyracksDataException {
                this.tRef.reset((IFrameTupleAccessor)this.tAccess, tIdx);
                eval.evaluate((IFrameTupleReference)this.tRef, this.p);
                int lim = bii.getIntegerValue(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                return lim;
            }

            public void flush() throws HyracksDataException {
                this.appender.flush(this.writer);
            }
        };
    }
}

