/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class RunningAggregateRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] outColumns;
    private final IRunningAggregateEvaluatorFactory[] runningAggregates;

    public RunningAggregateRuntimeFactory(int[] outColumns, IRunningAggregateEvaluatorFactory[] runningAggregates, int[] projectionList) {
        super(projectionList);
        this.outColumns = outColumns;
        this.runningAggregates = runningAggregates;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("running-aggregate [");
        for (i = 0; i < this.outColumns.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.outColumns[i]);
        }
        sb.append("] := [");
        for (i = 0; i < this.runningAggregates.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.runningAggregates[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws HyracksDataException {
        final int[] projectionToOutColumns = new int[this.projectionList.length];
        for (int j = 0; j < this.projectionList.length; ++j) {
            projectionToOutColumns[j] = Arrays.binarySearch(this.outColumns, this.projectionList[j]);
        }
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private final IPointable p = VoidPointable.FACTORY.createPointable();
            private final IRunningAggregateEvaluator[] raggs = new IRunningAggregateEvaluator[RunningAggregateRuntimeFactory.access$000(RunningAggregateRuntimeFactory.this).length];
            private final ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(RunningAggregateRuntimeFactory.access$100(RunningAggregateRuntimeFactory.this).length);
            private boolean first = true;

            @Override
            public void open() throws HyracksDataException {
                this.initAccessAppendRef(ctx);
                if (this.first) {
                    this.first = false;
                    int n = RunningAggregateRuntimeFactory.this.runningAggregates.length;
                    for (int i = 0; i < n; ++i) {
                        this.raggs[i] = RunningAggregateRuntimeFactory.this.runningAggregates[i].createRunningAggregateEvaluator(ctx);
                    }
                }
                for (int i = 0; i < RunningAggregateRuntimeFactory.this.runningAggregates.length; ++i) {
                    this.raggs[i].init();
                }
                super.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    this.produceTuple(this.tupleBuilder, (IFrameTupleAccessor)this.tAccess, t, this.tRef);
                    this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                }
            }

            private void produceTuple(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, FrameTupleReference tupleRef) throws HyracksDataException {
                tb.reset();
                for (int f = 0; f < RunningAggregateRuntimeFactory.this.projectionList.length; ++f) {
                    int k = projectionToOutColumns[f];
                    if (k >= 0) {
                        this.raggs[k].step((IFrameTupleReference)tupleRef, this.p);
                        tb.addField(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                        continue;
                    }
                    tb.addField(accessor, tIndex, RunningAggregateRuntimeFactory.this.projectionList[f]);
                }
            }

            public void flush() throws HyracksDataException {
                this.appender.flush(this.writer);
            }
        };
    }

    static /* synthetic */ int[] access$100(RunningAggregateRuntimeFactory x0) {
        return x0.projectionList;
    }
}

