/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.sort;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotPolicyFactory;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFrameMemoryManager;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFramePool;
import org.apache.hyracks.dataflow.std.sort.FrameSorterMergeSort;

public class InMemorySortRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] sortFields;
    private final INormalizedKeyComputerFactory[] keyNormalizerFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;

    public InMemorySortRuntimeFactory(int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, int[] projectionList) {
        INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray;
        if (firstKeyNormalizerFactory != null) {
            INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray2 = new INormalizedKeyComputerFactory[1];
            iNormalizedKeyComputerFactoryArray = iNormalizedKeyComputerFactoryArray2;
            iNormalizedKeyComputerFactoryArray2[0] = firstKeyNormalizerFactory;
        } else {
            iNormalizedKeyComputerFactoryArray = null;
        }
        this(sortFields, iNormalizedKeyComputerFactoryArray, comparatorFactories, projectionList);
    }

    public InMemorySortRuntimeFactory(int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, int[] projectionList) {
        super(projectionList);
        if (projectionList != null) {
            throw new NotImplementedException("Cannot push projection into InMemorySortRuntime.");
        }
        this.sortFields = sortFields;
        this.keyNormalizerFactories = keyNormalizerFactories;
        this.comparatorFactories = comparatorFactories;
    }

    @Override
    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws HyracksDataException {
        return new AbstractOneInputOneOutputPushRuntime(){
            FrameSorterMergeSort frameSorter = null;

            @Override
            public void open() throws HyracksDataException {
                super.open();
                if (this.frameSorter == null) {
                    VariableFrameMemoryManager manager = new VariableFrameMemoryManager((IFramePool)new VariableFramePool((IHyracksFrameMgrContext)ctx, -1), FrameFreeSlotPolicyFactory.createFreeSlotPolicy((EnumFreeSlotPolicy)EnumFreeSlotPolicy.LAST_FIT));
                    this.frameSorter = new FrameSorterMergeSort(ctx, (IFrameBufferManager)manager, -1, InMemorySortRuntimeFactory.this.sortFields, InMemorySortRuntimeFactory.this.keyNormalizerFactories, InMemorySortRuntimeFactory.this.comparatorFactories, this.outputRecordDesc);
                }
                this.frameSorter.reset();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.frameSorter.insertFrame(buffer);
            }

            public void close() throws HyracksDataException {
                Throwable failure = null;
                if (this.isOpen) {
                    try {
                        if (!this.failed) {
                            this.frameSorter.sort();
                            this.frameSorter.flush(this.writer);
                        }
                    }
                    catch (Throwable th) {
                        failure = th;
                        this.fail(th);
                    }
                    finally {
                        failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure);
                    }
                }
                if (failure != null) {
                    throw HyracksDataException.create(failure);
                }
            }
        };
    }
}

