/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.net.protocols.muxdemux.IChannelOpenListener;
import org.apache.hyracks.net.protocols.muxdemux.MultiplexedConnection;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import org.apache.hyracks.net.protocols.tcp.ITCPConnectionListener;
import org.apache.hyracks.net.protocols.tcp.TCPConnection;
import org.apache.hyracks.net.protocols.tcp.TCPEndpoint;

public class MuxDemux {
    private final InetSocketAddress localAddress;
    private final IChannelOpenListener channelOpenListener;
    private final int maxConnectionAttempts;
    private final Map<InetSocketAddress, MultiplexedConnection> connectionMap;
    private final TCPEndpoint tcpEndpoint;
    private final MuxDemuxPerformanceCounters perfCounters;
    private final IChannelInterfaceFactory channelInterfaceFatory;

    public MuxDemux(InetSocketAddress localAddress, IChannelOpenListener listener, int nThreads, int maxConnectionAttempts, IChannelInterfaceFactory channelInterfaceFatory) {
        this.localAddress = localAddress;
        this.channelOpenListener = listener;
        this.maxConnectionAttempts = maxConnectionAttempts;
        this.channelInterfaceFatory = channelInterfaceFatory;
        this.connectionMap = new HashMap<InetSocketAddress, MultiplexedConnection>();
        this.tcpEndpoint = new TCPEndpoint(new ITCPConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionEstablished(TCPConnection connection) {
                MultiplexedConnection mConn;
                MuxDemux muxDemux = MuxDemux.this;
                synchronized (muxDemux) {
                    mConn = (MultiplexedConnection)MuxDemux.this.connectionMap.get(connection.getRemoteAddress());
                }
                assert (mConn != null);
                mConn.setTCPConnection(connection);
                connection.setEventListener(mConn);
                connection.setAttachment(mConn);
            }

            @Override
            public void acceptedConnection(TCPConnection connection) {
                MultiplexedConnection mConn = new MultiplexedConnection(MuxDemux.this);
                mConn.setTCPConnection(connection);
                connection.setEventListener(mConn);
                connection.setAttachment(mConn);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionFailure(InetSocketAddress remoteAddress, IOException error) {
                MuxDemux muxDemux = MuxDemux.this;
                synchronized (muxDemux) {
                    MultiplexedConnection mConn = (MultiplexedConnection)MuxDemux.this.connectionMap.get(remoteAddress);
                    assert (mConn != null);
                    int nConnectionAttempts = mConn.getConnectionAttempts();
                    if (nConnectionAttempts > MuxDemux.this.maxConnectionAttempts) {
                        MuxDemux.this.connectionMap.remove(remoteAddress);
                        mConn.setConnectionFailure(new IOException(remoteAddress.toString() + ": " + error, error));
                    } else {
                        mConn.setConnectionAttempts(nConnectionAttempts + 1);
                        MuxDemux.this.tcpEndpoint.initiateConnection(remoteAddress);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionClosed(TCPConnection connection) {
                MuxDemux muxDemux = MuxDemux.this;
                synchronized (muxDemux) {
                    if (connection.getType() == TCPConnection.ConnectionType.OUTGOING) {
                        MuxDemux.this.connectionMap.remove(connection.getRemoteAddress());
                    }
                }
            }
        }, nThreads);
        this.perfCounters = new MuxDemuxPerformanceCounters();
    }

    public void start() throws IOException {
        this.tcpEndpoint.start(this.localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedConnection connect(InetSocketAddress remoteAddress) throws InterruptedException, NetException {
        MultiplexedConnection mConn;
        MuxDemux muxDemux = this;
        synchronized (muxDemux) {
            mConn = this.connectionMap.get(remoteAddress);
            if (mConn == null) {
                mConn = new MultiplexedConnection(this);
                this.connectionMap.put(remoteAddress, mConn);
                this.tcpEndpoint.initiateConnection(remoteAddress);
            }
        }
        mConn.waitUntilConnected();
        return mConn;
    }

    IChannelOpenListener getChannelOpenListener() {
        return this.channelOpenListener;
    }

    public InetSocketAddress getLocalAddress() {
        return this.tcpEndpoint.getLocalAddress();
    }

    public MuxDemuxPerformanceCounters getPerformanceCounters() {
        return this.perfCounters;
    }

    public IChannelInterfaceFactory getChannelInterfaceFactory() {
        return this.channelInterfaceFatory;
    }
}

