/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IBufferFactory;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.IConnectionWriterState;
import org.apache.hyracks.api.comm.MuxDemuxCommand;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.net.protocols.muxdemux.AbstractChannelWriteInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FullFrameChannelWriteInterface
extends AbstractChannelWriteInterface {
    private static final Logger LOGGER = LogManager.getLogger();

    FullFrameChannelWriteInterface(IChannelControlBlock ccb) {
        super(ccb);
    }

    public void write(IConnectionWriterState writerState) throws NetException {
        if (this.currentWriteBuffer == null) {
            this.currentWriteBuffer = (ByteBuffer)this.wiFullQueue.poll();
        }
        if (this.currentWriteBuffer != null) {
            int size = Math.min(this.currentWriteBuffer.remaining(), this.credits);
            if (size > 0) {
                this.credits -= size;
                writerState.getCommand().setChannelId(this.channelId);
                writerState.getCommand().setCommandType(MuxDemuxCommand.CommandType.DATA);
                writerState.getCommand().setData(size);
                writerState.reset(this.currentWriteBuffer, size, this.ccb);
            } else {
                this.adjustChannelWritability();
            }
        } else if (this.ecode.get() == 1 && !this.ecodeSent) {
            writerState.getCommand().setChannelId(this.channelId);
            writerState.getCommand().setCommandType(MuxDemuxCommand.CommandType.ERROR);
            writerState.getCommand().setData(1);
            writerState.reset(null, 0, null);
            this.ecodeSent = true;
            this.ccb.reportLocalEOS();
            this.adjustChannelWritability();
        } else if (this.isPendingCloseWrite()) {
            writerState.getCommand().setChannelId(this.channelId);
            writerState.getCommand().setCommandType(MuxDemuxCommand.CommandType.CLOSE_CHANNEL);
            writerState.getCommand().setData(0);
            writerState.reset(null, 0, null);
            this.eosSent = true;
            this.ccb.reportLocalEOS();
            this.adjustChannelWritability();
        }
    }

    public void setBufferFactory(IBufferFactory bufferFactory, int limit, int frameSize) {
        if (!this.channelWritabilityState) {
            this.ccb.markPendingWrite();
        }
        this.channelWritabilityState = true;
        if (this.eos) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Received duplicate close() on channel: " + this.channelId);
            }
            return;
        }
        this.eos = true;
    }
}

