/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.hyracks.api.comm.IBufferFactory;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.net.protocols.muxdemux.AbstractChannelReadInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FullFrameChannelReadInterface
extends AbstractChannelReadInterface {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BlockingDeque<ByteBuffer> riEmptyStack;
    private final IChannelControlBlock ccb;

    public FullFrameChannelReadInterface(IChannelControlBlock ccb) {
        this.ccb = ccb;
        this.riEmptyStack = new LinkedBlockingDeque<ByteBuffer>();
        this.credits = 0;
        this.emptyBufferAcceptor = buffer -> {
            if (ccb.isRemotelyClosed()) {
                return;
            }
            int delta = buffer.remaining();
            this.riEmptyStack.push(buffer);
            ccb.addPendingCredits(delta);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(SocketChannel sc, int size) throws IOException, NetException {
        while (size > 0) {
            if (this.currentReadBuffer == null) {
                this.currentReadBuffer = this.riEmptyStack.poll();
                if (this.currentReadBuffer == null) {
                    this.currentReadBuffer = this.bufferFactory.createBuffer();
                }
            }
            if (this.currentReadBuffer == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("{} read buffers exceeded. Current empty buffers: {}", (Object)this.ccb, (Object)this.riEmptyStack.size());
                }
                throw new IllegalStateException(this.ccb + " read buffers exceeded");
            }
            int rSize = Math.min(size, this.currentReadBuffer.remaining());
            if (rSize > 0) {
                int len;
                this.currentReadBuffer.limit(this.currentReadBuffer.position() + rSize);
                try {
                    len = sc.read(this.currentReadBuffer);
                    if (len < 0) {
                        throw new NetException("Socket Closed");
                    }
                }
                finally {
                    this.currentReadBuffer.limit(this.currentReadBuffer.capacity());
                }
                size -= len;
                if (len < rSize) {
                    return size;
                }
            } else {
                return size;
            }
            if (this.currentReadBuffer.remaining() > 0) continue;
            this.flush();
        }
        return size;
    }

    @Override
    public void setBufferFactory(IBufferFactory bufferFactory, int limit, int frameSize) {
        super.setBufferFactory(bufferFactory, limit, frameSize);
        this.ccb.addPendingCredits(limit * frameSize);
    }
}

