/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.comm.IChannelReadInterface;
import org.apache.hyracks.api.comm.IChannelWriteInterface;
import org.apache.hyracks.api.comm.IConnectionWriterState;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.net.protocols.muxdemux.ChannelSet;
import org.apache.hyracks.net.protocols.muxdemux.MultiplexedConnection;

public class ChannelControlBlock
implements IChannelControlBlock {
    private final ChannelSet cSet;
    private final int channelId;
    private final IChannelReadInterface ri;
    private final IChannelWriteInterface wi;
    private final AtomicBoolean localClose;
    private final AtomicBoolean localCloseAck;
    private final AtomicBoolean remoteClose;
    private final AtomicBoolean remoteCloseAck;

    ChannelControlBlock(ChannelSet cSet, int channelId, IChannelInterfaceFactory interfaceFactory) {
        this.cSet = cSet;
        this.channelId = channelId;
        this.localClose = new AtomicBoolean();
        this.localCloseAck = new AtomicBoolean();
        this.remoteClose = new AtomicBoolean();
        this.remoteCloseAck = new AtomicBoolean();
        this.ri = interfaceFactory.createReadInterface((IChannelControlBlock)this);
        this.wi = interfaceFactory.createWriteInterface((IChannelControlBlock)this);
    }

    public int getChannelId() {
        return this.channelId;
    }

    public IChannelReadInterface getReadInterface() {
        return this.ri;
    }

    public IChannelWriteInterface getWriteInterface() {
        return this.wi;
    }

    synchronized void write(MultiplexedConnection.WriterState writerState) throws NetException {
        this.wi.write((IConnectionWriterState)writerState);
    }

    public synchronized void writeComplete() {
        this.wi.writeComplete();
    }

    synchronized int read(SocketChannel sc, int size) throws IOException, NetException {
        return this.ri.read(sc, size);
    }

    int getReadCredits() {
        return this.ri.getCredits();
    }

    void setReadCredits(int credits) {
        this.ri.setReadCredits(credits);
    }

    public synchronized void addWriteCredits(int delta) {
        this.wi.addCredits(delta);
        this.wi.adjustChannelWritability();
    }

    synchronized void reportRemoteEOS() {
        this.ri.flush();
        this.ri.getFullBufferAcceptor().close();
        this.remoteClose.set(true);
    }

    void reportRemoteEOSAck() {
        this.remoteCloseAck.set(true);
    }

    boolean getRemoteEOS() {
        return this.remoteClose.get();
    }

    void reportLocalEOSAck() {
        this.localCloseAck.set(true);
    }

    void reportRemoteError(int ecode) {
        this.ri.flush();
        this.ri.getFullBufferAcceptor().error(ecode);
        this.remoteClose.set(true);
    }

    boolean completelyClosed() {
        return this.localCloseAck.get() && this.remoteCloseAck.get();
    }

    public boolean isRemotelyClosed() {
        return this.remoteCloseAck.get();
    }

    public void reportLocalEOS() {
        this.localClose.set(true);
    }

    public void addPendingCredits(int credit) {
        this.cSet.addPendingCredits(this.channelId, credit);
    }

    public void unmarkPendingWrite() {
        this.cSet.unmarkPendingWrite(this.channelId);
    }

    public void markPendingWrite() {
        this.cSet.markPendingWrite(this.channelId);
    }

    public String toString() {
        return "Channel:" + this.channelId + "[localClose: " + this.localClose + " localCloseAck: " + this.localCloseAck + " remoteClose: " + this.remoteClose + " remoteCloseAck:" + this.remoteCloseAck + " readCredits: " + this.ri.getCredits() + " writeCredits: " + this.wi.getCredits() + "]";
    }

    public InetSocketAddress getRemoteAddress() {
        return this.cSet.getMultiplexedConnection().getRemoteAddress();
    }
}

