/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.comm.IBufferAcceptor;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.IChannelWriteInterface;
import org.apache.hyracks.api.comm.ICloseableBufferAcceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractChannelWriteInterface
implements IChannelWriteInterface {
    public static final int NO_ERROR_CODE = 0;
    public static final int CONNECTION_LOST_ERROR_CODE = -1;
    public static final int REMOTE_ERROR_CODE = 1;
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IChannelControlBlock ccb;
    protected final Queue<ByteBuffer> wiFullQueue;
    protected final AtomicInteger ecode = new AtomicInteger(0);
    protected boolean channelWritabilityState;
    protected final int channelId;
    protected IBufferAcceptor eba;
    protected int credits;
    protected boolean eos;
    protected boolean eosSent;
    protected boolean ecodeSent;
    protected ByteBuffer currentWriteBuffer;
    private final ICloseableBufferAcceptor fba;

    public AbstractChannelWriteInterface(IChannelControlBlock ccb) {
        this.ccb = ccb;
        this.channelId = ccb.getChannelId();
        this.wiFullQueue = new ArrayDeque<ByteBuffer>();
        this.fba = new CloseableBufferAcceptor();
        this.credits = 0;
        this.eos = false;
        this.eosSent = false;
        this.ecodeSent = false;
    }

    public void writeComplete() {
        if (this.currentWriteBuffer.remaining() <= 0) {
            this.currentWriteBuffer.clear();
            this.eba.accept(this.currentWriteBuffer);
            this.currentWriteBuffer = null;
            this.adjustChannelWritability();
        }
    }

    private boolean computeWritability() {
        boolean writableDataPresent;
        boolean bl = writableDataPresent = this.currentWriteBuffer != null || !this.wiFullQueue.isEmpty();
        if (writableDataPresent) {
            return this.credits > 0;
        }
        if (this.isPendingCloseWrite()) {
            return true;
        }
        return this.ecode.get() == 1 && !this.ecodeSent;
    }

    public void adjustChannelWritability() {
        boolean writable = this.computeWritability();
        if (writable) {
            if (!this.channelWritabilityState) {
                this.ccb.markPendingWrite();
            }
        } else if (this.channelWritabilityState) {
            this.ccb.unmarkPendingWrite();
        }
        this.channelWritabilityState = writable;
    }

    public void addCredits(int credit) {
        this.credits += credit;
    }

    public void setEmptyBufferAcceptor(IBufferAcceptor emptyBufferAcceptor) {
        this.eba = emptyBufferAcceptor;
    }

    public ICloseableBufferAcceptor getFullBufferAcceptor() {
        return this.fba;
    }

    public int getCredits() {
        return this.credits;
    }

    protected boolean isPendingCloseWrite() {
        return this.eos && !this.eosSent && !this.ecodeSent;
    }

    private class CloseableBufferAcceptor
    implements ICloseableBufferAcceptor {
        private CloseableBufferAcceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(ByteBuffer buffer) {
            IChannelControlBlock iChannelControlBlock = AbstractChannelWriteInterface.this.ccb;
            synchronized (iChannelControlBlock) {
                AbstractChannelWriteInterface.this.wiFullQueue.add(buffer);
                AbstractChannelWriteInterface.this.adjustChannelWritability();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            IChannelControlBlock iChannelControlBlock = AbstractChannelWriteInterface.this.ccb;
            synchronized (iChannelControlBlock) {
                if (AbstractChannelWriteInterface.this.eos) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Received duplicate close() on channel: " + AbstractChannelWriteInterface.this.ccb.getChannelId());
                    }
                    return;
                }
                AbstractChannelWriteInterface.this.eos = true;
                if (AbstractChannelWriteInterface.this.ecode.get() != 1) {
                    AbstractChannelWriteInterface.this.adjustChannelWritability();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void error(int ecode) {
            AbstractChannelWriteInterface.this.ecode.set(ecode);
            if (ecode == -1) {
                return;
            }
            IChannelControlBlock iChannelControlBlock = AbstractChannelWriteInterface.this.ccb;
            synchronized (iChannelControlBlock) {
                AbstractChannelWriteInterface.this.adjustChannelWritability();
            }
        }
    }
}

