/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.shutdown;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.control.common.shutdown.IShutdownStatusConditionVariable;

public class ShutdownRun
implements IShutdownStatusConditionVariable {
    private final Set<String> shutdownNodeIds = new TreeSet<String>();
    private boolean shutdownSuccess = false;
    private static final long SHUTDOWN_TIMER_MS = TimeUnit.SECONDS.toMillis(30L);

    public ShutdownRun(Collection<String> nodeIds) {
        this.shutdownNodeIds.addAll(nodeIds);
    }

    public synchronized void notifyShutdown(String nodeId) {
        this.shutdownNodeIds.remove(nodeId);
        if (this.shutdownNodeIds.isEmpty()) {
            this.shutdownSuccess = true;
            this.notifyAll();
        }
    }

    @Override
    public synchronized boolean waitForCompletion() throws Exception {
        if (this.shutdownNodeIds.isEmpty()) {
            this.shutdownSuccess = true;
        } else {
            this.wait(SHUTDOWN_TIMER_MS);
        }
        return this.shutdownSuccess;
    }

    public synchronized Set<String> getRemainingNodes() {
        return this.shutdownNodeIds;
    }
}

