/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeAbstractCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class LSMRTreeSearchCursor
extends LSMRTreeAbstractCursor {
    private int currentCursor = 0;
    private final PermutingTupleReference btreeTuple;
    private boolean resultOfsearchCallbackProceed = false;

    public LSMRTreeSearchCursor(ILSMIndexOperationContext opCtx, int[] buddyBTreeFields) {
        super(opCtx);
        this.btreeTuple = new PermutingTupleReference(buddyBTreeFields);
    }

    @Override
    public void doDestroy() throws HyracksDataException {
        super.doDestroy();
        this.currentCursor = 0;
    }

    public void doClose() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        this.currentCursor = 0;
        this.foundNext = false;
        try {
            for (int i = 0; i < this.numberOfTrees; ++i) {
                this.rtreeCursors[i].close();
                this.btreeCursors[i].close();
            }
            this.rtreeCursors = null;
            this.btreeCursors = null;
        }
        finally {
            this.lsmHarness.endSearch(this.opCtx);
        }
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    private ILSMComponentFilter getFilter() {
        return this.foundNext ? ((ILSMComponent)this.operationalComponents.get(this.currentCursor)).getLSMComponentFilter() : null;
    }

    private void searchNextCursor() throws HyracksDataException {
        if (this.currentCursor < this.numberOfTrees) {
            this.rtreeCursors[this.currentCursor].close();
            this.rtreeAccessors[this.currentCursor].search((IIndexCursor)this.rtreeCursors[this.currentCursor], (ISearchPredicate)this.rtreeSearchPredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doHasNext() throws HyracksDataException {
        if (this.foundNext) {
            return true;
        }
        while (this.currentCursor < this.numberOfTrees) {
            while (this.rtreeCursors[this.currentCursor].hasNext()) {
                this.rtreeCursors[this.currentCursor].next();
                ITupleReference currentTuple = this.rtreeCursors[this.currentCursor].getTuple();
                this.resultOfsearchCallbackProceed = this.currentCursor == 0 && this.includeMutableComponent ? this.searchCallback.proceed(currentTuple) : true;
                this.btreeTuple.reset(this.rtreeCursors[this.currentCursor].getTuple());
                boolean killerTupleFound = false;
                for (int i = 0; i < this.currentCursor && !killerTupleFound; ++i) {
                    if (this.bloomFilters[i] != null && this.bloomFilters[i].contains((ITupleReference)this.btreeTuple, this.hashes)) continue;
                    this.btreeCursors[i].close();
                    this.btreeRangePredicate.setHighKey((ITupleReference)this.btreeTuple, true);
                    this.btreeRangePredicate.setLowKey((ITupleReference)this.btreeTuple, true);
                    this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.btreeRangePredicate);
                    try {
                        if (!this.btreeCursors[i].hasNext()) continue;
                        killerTupleFound = true;
                        continue;
                    }
                    finally {
                        this.btreeCursors[i].close();
                    }
                }
                if (killerTupleFound) continue;
                this.frameTuple = currentTuple;
                this.foundNext = true;
                return true;
            }
            this.rtreeCursors[this.currentCursor].close();
            ++this.currentCursor;
            this.searchNextCursor();
        }
        return false;
    }

    public void doNext() throws HyracksDataException {
        this.foundNext = false;
    }

    @Override
    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        super.doOpen(initialState, searchPred);
        this.searchNextCursor();
    }

    @Override
    public boolean getSearchOperationCallbackProceedResult() {
        return this.resultOfsearchCallbackProceed;
    }
}

