/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;

public class LSMBTreeWithBuddyFileManager
extends AbstractLSMIndexFileManager {
    private final TreeIndexFactory<? extends ITreeIndex> btreeFactory;
    private final TreeIndexFactory<? extends ITreeIndex> buddyBtreeFactory;
    private static FilenameFilter btreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith("b");
    private static FilenameFilter buddyBtreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith("d");

    public LSMBTreeWithBuddyFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, TreeIndexFactory<? extends ITreeIndex> buddyBtreeFactory) {
        super(ioManager, file, null);
        this.buddyBtreeFactory = buddyBtreeFactory;
        this.btreeFactory = btreeFactory;
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String baseName = this.getNextComponentSequence(btreeFilter);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), this.baseDir.getChild(baseName + "_" + "d"), this.baseDir.getChild(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) {
        String baseName = IndexComponentFileReference.getMergeSequence((String)firstFileName, (String)lastFileName);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), this.baseDir.getChild(baseName + "_" + "d"), this.baseDir.getChild(baseName + "_" + "f"));
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allBTreeFiles = new ArrayList();
        ArrayList allBuddyBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        FilenameFilter transactionFilefilter = this.getTransactionFileFilter(false);
        this.cleanupAndGetValidFilesInternal(this.getCompoundFilter(btreeFilter, transactionFilefilter), this.btreeFactory, allBTreeFiles, this.btreeFactory.getBufferCache());
        HashSet<String> btreeFilesSet = new HashSet<String>();
        for (IndexComponentFileReference cmpFileName : allBTreeFiles) {
            btreeFilesSet.add(cmpFileName.getSequence());
        }
        this.validateFiles(btreeFilesSet, allBuddyBTreeFiles, this.getCompoundFilter(buddyBtreeFilter, transactionFilefilter), this.buddyBtreeFactory, this.btreeFactory.getBufferCache());
        this.validateFiles(btreeFilesSet, allBloomFilterFiles, this.getCompoundFilter(bloomFilterFilter, transactionFilefilter), null, this.btreeFactory.getBufferCache());
        if (allBTreeFiles.size() != allBuddyBTreeFiles.size() || allBTreeFiles.size() != allBloomFilterFiles.size()) {
            throw HyracksDataException.create((int)87, (Serializable[])new Serializable[]{this.baseDir});
        }
        if (allBTreeFiles.isEmpty() || allBuddyBTreeFiles.isEmpty() || allBloomFilterFiles.isEmpty()) {
            return validFiles;
        }
        if (allBTreeFiles.size() == 1 && allBuddyBTreeFiles.size() == 1 && allBloomFilterFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(((IndexComponentFileReference)allBTreeFiles.get(0)).getFileRef(), ((IndexComponentFileReference)allBuddyBTreeFiles.get(0)).getFileRef(), ((IndexComponentFileReference)allBloomFilterFiles.get(0)).getFileRef()));
            return validFiles;
        }
        Collections.sort(allBTreeFiles);
        Collections.sort(allBuddyBTreeFiles);
        Collections.sort(allBloomFilterFiles);
        ArrayList<IndexComponentFileReference> validComparableBTreeFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastBTree = (IndexComponentFileReference)allBTreeFiles.get(0);
        validComparableBTreeFiles.add(lastBTree);
        ArrayList<IndexComponentFileReference> validComparableBuddyBTreeFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastBuddyBTree = (IndexComponentFileReference)allBuddyBTreeFiles.get(0);
        validComparableBuddyBTreeFiles.add(lastBuddyBTree);
        ArrayList<IndexComponentFileReference> validComparableBloomFilterFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(0);
        validComparableBloomFilterFiles.add(lastBloomFilter);
        for (int i = 1; i < allBTreeFiles.size(); ++i) {
            IndexComponentFileReference currentBTree = (IndexComponentFileReference)allBTreeFiles.get(i);
            IndexComponentFileReference currentBuddyBTree = (IndexComponentFileReference)allBuddyBTreeFiles.get(i);
            IndexComponentFileReference currentBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(i);
            if (currentBTree.isMoreRecentThan(lastBTree) && currentBuddyBTree.isMoreRecentThan(lastBuddyBTree) && currentBloomFilter.isMoreRecentThan(lastBloomFilter)) {
                validComparableBTreeFiles.add(currentBTree);
                validComparableBuddyBTreeFiles.add(currentBuddyBTree);
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastBTree = currentBTree;
                lastBuddyBTree = currentBuddyBTree;
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentBTree.isWithin(lastBTree) && currentBuddyBTree.isWithin(lastBuddyBTree) && currentBloomFilter.isWithin(lastBloomFilter)) {
                this.delete(this.treeFactory.getBufferCache(), currentBTree.getFullPath());
                this.delete(this.treeFactory.getBufferCache(), currentBuddyBTree.getFullPath());
                this.delete(this.treeFactory.getBufferCache(), currentBloomFilter.getFullPath());
                continue;
            }
            throw HyracksDataException.create((int)84, (Serializable[])new Serializable[]{this.baseDir});
        }
        validComparableBTreeFiles.sort(this.recencyCmp);
        validComparableBuddyBTreeFiles.sort(this.recencyCmp);
        validComparableBloomFilterFiles.sort(this.recencyCmp);
        Iterator btreeFileIter = validComparableBTreeFiles.iterator();
        Iterator buddyBtreeFileIter = validComparableBuddyBTreeFiles.iterator();
        Iterator bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        while (btreeFileIter.hasNext() && buddyBtreeFileIter.hasNext()) {
            IndexComponentFileReference cmpBTreeFileName = (IndexComponentFileReference)btreeFileIter.next();
            IndexComponentFileReference cmpBuddyBTreeFileName = (IndexComponentFileReference)buddyBtreeFileIter.next();
            IndexComponentFileReference cmpBloomFilterFileName = (IndexComponentFileReference)bloomFilterFileIter.next();
            validFiles.add(new LSMComponentFileReferences(cmpBTreeFileName.getFileRef(), cmpBuddyBTreeFileName.getFileRef(), cmpBloomFilterFileName.getFileRef()));
        }
        return validFiles;
    }

    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        String baseName = this.getNextComponentSequence(btreeFilter);
        Files.createFile(Paths.get(this.baseDir + ".T" + baseName, new String[0]), new FileAttribute[0]);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), this.baseDir.getChild(baseName + "_" + "d"), this.baseDir.getChild(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        String[] files = this.baseDir.getFile().list(txnFileNameFilter);
        if (files.length == 0) {
            return null;
        }
        if (files.length != 1) {
            throw HyracksDataException.create((int)85, (Serializable[])new Serializable[]{this.baseDir});
        }
        FilenameFilter transactionFilter = this.getTransactionFileFilter(true);
        files = this.baseDir.getFile().list(transactionFilter);
        if (files.length < 3) {
            throw HyracksDataException.create((int)87, (Serializable[])new Serializable[]{this.baseDir});
        }
        IoUtil.delete((FileReference)this.baseDir.getChild(files[0]));
        FileReference bTreeFileRef = null;
        FileReference buddyBTreeFileRef = null;
        FileReference bloomFilterFileRef = null;
        for (String fileName : files) {
            if (fileName.endsWith("b")) {
                bTreeFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            if (fileName.endsWith("d")) {
                buddyBTreeFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            if (fileName.endsWith("f")) {
                bloomFilterFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            throw HyracksDataException.create((int)86, (Serializable[])new Serializable[]{fileName});
        }
        return new LSMComponentFileReferences(bTreeFileRef, buddyBTreeFileRef, bloomFilterFileRef);
    }
}

