/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.HashSet;
import java.util.Set;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.DiskBTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;

public class LSMBTreeDiskComponent
extends AbstractLSMDiskComponent {
    protected final DiskBTree btree;

    public LSMBTreeDiskComponent(AbstractLSMIndex lsmIndex, DiskBTree btree, ILSMComponentFilter filter) {
        super(lsmIndex, LSMBTreeDiskComponent.getMetadataPageManager((BTree)btree), filter);
        this.btree = btree;
    }

    public DiskBTree getIndex() {
        return this.btree;
    }

    public DiskBTree getMetadataHolder() {
        return this.btree;
    }

    public long getComponentSize() {
        return LSMBTreeDiskComponent.getComponentSize((BTree)this.btree);
    }

    public int getFileReferenceCount() {
        return LSMBTreeDiskComponent.getFileReferenceCount((BTree)this.btree);
    }

    public Set<String> getLSMComponentPhysicalFiles() {
        return LSMBTreeDiskComponent.getFiles((BTree)this.btree);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.btree.getFileReference().getRelativePath();
    }

    static IMetadataPageManager getMetadataPageManager(BTree btree) {
        return (IMetadataPageManager)btree.getPageManager();
    }

    static long getComponentSize(BTree btree) {
        return btree.getFileReference().getFile().length();
    }

    static int getFileReferenceCount(BTree btree) {
        return btree.getBufferCache().getFileReferenceCount(btree.getFileId());
    }

    static Set<String> getFiles(BTree btree) {
        HashSet<String> files = new HashSet<String>();
        files.add(btree.getFileReference().getFile().getAbsolutePath());
        return files;
    }
}

