/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.parsers;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class UTF8StringParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new UTF8StringParserFactory();
    private static final long serialVersionUID = 1L;

    private UTF8StringParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return new IValueParser(){
            private UTF8StringWriter writer = new UTF8StringWriter();

            @Override
            public void parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                try {
                    this.writer.writeUTF8(buffer, start, length, out);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

