/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.parsers;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class LongParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new LongParserFactory();
    private static final long serialVersionUID = 1L;

    private LongParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return new IValueParser(){

            @Override
            public void parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                char ch;
                int i;
                long n = 0L;
                int sign = 1;
                boolean pre = true;
                block13: for (i = 0; pre && i < length; ++i) {
                    char ch2 = buffer[i + start];
                    switch (ch2) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block13;
                        }
                        case '-': {
                            sign = -1;
                            pre = false;
                            continue block13;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            pre = false;
                            n = n * 10L + (long)(ch2 - 48);
                            continue block13;
                        }
                        default: {
                            String errorString = new String(buffer, i + start, length - i);
                            throw new HyracksDataException("Long Parser - a digit is expected. But, encountered this character: " + ch2 + " in the incoming input: " + errorString);
                        }
                    }
                }
                boolean post = false;
                while (!post && i < length) {
                    ch = buffer[i + start];
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            n = n * 10L + (long)(ch - 48);
                            break;
                        }
                        default: {
                            String errorString = new String(buffer, i + start, length - i);
                            throw new HyracksDataException("Long Parser - a digit is expected. But, encountered this character: " + ch + " in the incoming input: " + errorString);
                        }
                    }
                    ++i;
                }
                while (i < length) {
                    ch = buffer[i + start];
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            String errorString = new String(buffer, i + start, length - i);
                            throw new HyracksDataException("Long Parser - a whitespace, tab, new line, or form-feed expected. But, encountered this character: " + ch + " in the incoming input: " + errorString);
                        }
                    }
                    ++i;
                }
                try {
                    out.writeLong(n * (long)sign);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

