/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.util.container;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;

public class ListObjectPool<E, T>
implements IObjectPool<E, T> {
    private IObjectFactory<E, T> factory;
    private List<E> pool = new ArrayList();
    private List<T> args = new ArrayList<T>();
    private BitSet usedBits = new BitSet();

    public ListObjectPool(IObjectFactory<E, T> factory) {
        this.factory = factory;
    }

    @Override
    public E allocate(T arg) {
        int freeSlot = -1;
        while (freeSlot + 1 < this.pool.size() && (freeSlot = this.usedBits.nextClearBit(freeSlot + 1)) < this.pool.size()) {
            if ((arg != null || this.args.get(freeSlot) != null) && (arg == null || this.args.get(freeSlot) == null || !arg.equals(this.args.get(freeSlot)))) continue;
            this.usedBits.set(freeSlot);
            return this.pool.get(freeSlot);
        }
        E element = this.factory.create(arg);
        this.pool.add(element);
        this.args.add(arg);
        this.usedBits.set(this.pool.size() - 1);
        return element;
    }

    @Override
    public void reset() {
        this.usedBits.clear();
    }
}

