/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class ArrayRangeTypeComputer
extends AbstractResultTypeComputer {
    public static final ArrayRangeTypeComputer INSTANCE = new ArrayRangeTypeComputer();
    public static final AOrderedListType LONG_LIST = new AOrderedListType(BuiltinType.AINT64, null);
    public static final AOrderedListType DOUBLE_LIST = new AOrderedListType(BuiltinType.ADOUBLE, null);

    private ArrayRangeTypeComputer() {
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType step;
        if (strippedInputTypes.length != 2 && strippedInputTypes.length != 3) {
            String functionName = ((AbstractFunctionCallExpression)expr).getFunctionIdentifier().getName();
            throw new CompilationException(1087, expr.getSourceLocation(), new Serializable[]{functionName});
        }
        IAType startNum = strippedInputTypes[0];
        IAType endNum = strippedInputTypes[1];
        IAType iAType = step = strippedInputTypes.length == 3 ? strippedInputTypes[2] : null;
        if (ATypeHierarchy.canPromote(startNum.getTypeTag(), ATypeTag.BIGINT) && ATypeHierarchy.canPromote(endNum.getTypeTag(), ATypeTag.BIGINT) && (step == null || ATypeHierarchy.canPromote(step.getTypeTag(), ATypeTag.BIGINT))) {
            return LONG_LIST;
        }
        if (ATypeHierarchy.canPromote(startNum.getTypeTag(), ATypeTag.DOUBLE) && ATypeHierarchy.canPromote(endNum.getTypeTag(), ATypeTag.DOUBLE) && (step == null || ATypeHierarchy.canPromote(step.getTypeTag(), ATypeTag.DOUBLE))) {
            return DOUBLE_LIST;
        }
        return BuiltinType.ANY;
    }
}

