/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.nonvisitor;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.VarLengthTypeTrait;

public class AIntervalPointable
extends AbstractPointable {
    public static final AIntervalPointableFactory FACTORY = new AIntervalPointableFactory();
    public static final IObjectFactory<IPointable, ATypeTag> ALLOCATOR = new IObjectFactory<IPointable, ATypeTag>(){

        @Override
        public IPointable create(ATypeTag type) {
            return new AIntervalPointable();
        }
    };
    private static final int TAG_SIZE = 1;

    public byte getType() {
        return BytePointable.getByte((byte[])this.bytes, (int)this.getTypeOffset());
    }

    public ATypeTag getTypeTag() {
        return EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.getType());
    }

    public int getTypeOffset() {
        return this.start;
    }

    public int getTypeSize() {
        return 1;
    }

    public void getStart(IPointable start) throws HyracksDataException {
        start.set(this.bytes, this.getStartOffset(), this.getStartSize());
    }

    public int getStartOffset() {
        return this.getTypeOffset() + this.getTypeSize();
    }

    public int getStartSize() throws HyracksDataException {
        switch (this.getTypeTag()) {
            case DATE: 
            case TIME: {
                return 4;
            }
            case DATETIME: {
                return 8;
            }
        }
        throw new HyracksDataException("Unsupported interval type: " + this.getTypeTag() + ".");
    }

    public long getStartValue() throws HyracksDataException {
        switch (this.getTypeTag()) {
            case DATE: 
            case TIME: {
                return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getStartOffset());
            }
            case DATETIME: {
                return LongPointable.getLong((byte[])this.bytes, (int)this.getStartOffset());
            }
        }
        throw new HyracksDataException("Unsupported interval type: " + this.getTypeTag() + ".");
    }

    public void getEnd(IPointable start) throws HyracksDataException {
        start.set(this.bytes, this.getEndOffset(), this.getEndSize());
    }

    public int getEndOffset() throws HyracksDataException {
        return this.getStartOffset() + this.getStartSize();
    }

    public int getEndSize() throws HyracksDataException {
        switch (this.getTypeTag()) {
            case DATE: 
            case TIME: {
                return 4;
            }
            case DATETIME: {
                return 8;
            }
        }
        throw new HyracksDataException("Unsupported interval type: " + this.getTypeTag() + ".");
    }

    public long getEndValue() throws HyracksDataException {
        switch (this.getTypeTag()) {
            case DATE: 
            case TIME: {
                return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getEndOffset());
            }
            case DATETIME: {
                return LongPointable.getLong((byte[])this.bytes, (int)this.getEndOffset());
            }
        }
        throw new HyracksDataException("Unsupported interval type: " + this.getTypeTag() + ".");
    }

    public static final class AIntervalPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        public IPointable createPointable() {
            return new AIntervalPointable();
        }

        public ITypeTraits getTypeTraits() {
            return VarLengthTypeTrait.INSTANCE;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

