/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.cast;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.AListCaster;
import org.apache.asterix.om.pointables.cast.ARecordCaster;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ACastVisitor
implements IVisitablePointableVisitor<Void, Triple<IVisitablePointable, IAType, Boolean>> {
    private final Map<IVisitablePointable, ARecordCaster> raccessorToCaster = new HashMap<IVisitablePointable, ARecordCaster>();
    private final Map<IVisitablePointable, AListCaster> laccessorToCaster = new HashMap<IVisitablePointable, AListCaster>();
    private final ArrayBackedValueStorage castBuffer = new ArrayBackedValueStorage();
    private final boolean strictDemote;

    public ACastVisitor() {
        this(true);
    }

    public ACastVisitor(boolean strictDemote) {
        this.strictDemote = strictDemote;
    }

    @Override
    public Void visit(AListVisitablePointable accessor, Triple<IVisitablePointable, IAType, Boolean> arg) throws HyracksDataException {
        AListCaster caster = this.laccessorToCaster.get(accessor);
        if (caster == null) {
            caster = new AListCaster();
            this.laccessorToCaster.put(accessor, caster);
        }
        if (((IAType)arg.second).getTypeTag().equals(ATypeTag.ANY)) {
            arg.second = accessor.ordered() ? DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE : DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
        }
        caster.castList(accessor, (IVisitablePointable)arg.first, (AbstractCollectionType)arg.second, this);
        return null;
    }

    @Override
    public Void visit(ARecordVisitablePointable accessor, Triple<IVisitablePointable, IAType, Boolean> arg) throws HyracksDataException {
        ARecordCaster caster = this.raccessorToCaster.get(accessor);
        if (caster == null) {
            caster = new ARecordCaster();
            this.raccessorToCaster.put(accessor, caster);
        }
        if (((IAType)arg.second).getTypeTag().equals(ATypeTag.ANY)) {
            arg.second = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
        }
        ARecordType resultType = (ARecordType)arg.second;
        caster.castRecord(accessor, (IVisitablePointable)arg.first, resultType, this);
        return null;
    }

    @Override
    public Void visit(AFlatValuePointable accessor, Triple<IVisitablePointable, IAType, Boolean> arg) throws HyracksDataException {
        if (arg.second == null) {
            ((IVisitablePointable)arg.first).set((IValueReference)accessor);
            return null;
        }
        ATypeTag reqTypeTag = ((IAType)arg.second).getTypeTag();
        if (reqTypeTag == ATypeTag.ANY) {
            ((IVisitablePointable)arg.first).set((IValueReference)accessor);
            return null;
        }
        ATypeTag inputTypeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(accessor.getByteArray()[accessor.getStartOffset()]);
        if (!this.needPromote(inputTypeTag, reqTypeTag)) {
            ((IVisitablePointable)arg.first).set((IValueReference)accessor);
        } else {
            try {
                this.castBuffer.reset();
                ATypeHierarchy.convertNumericTypeByteArray(accessor.getByteArray(), accessor.getStartOffset(), accessor.getLength(), reqTypeTag, this.castBuffer.getDataOutput(), this.strictDemote);
                ((IVisitablePointable)arg.first).set((IValueReference)this.castBuffer);
            }
            catch (IOException e1) {
                throw new HyracksDataException("Type mismatch: cannot cast the " + inputTypeTag + " type to the " + reqTypeTag + " type.");
            }
        }
        return null;
    }

    private boolean needPromote(ATypeTag tag0, ATypeTag tag1) {
        return tag0 != tag1 && tag0 != ATypeTag.NULL && tag0 != ATypeTag.MISSING;
    }
}

