/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables;

import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class PointableAllocator {
    private IObjectPool<AFlatValuePointable, IAType> flatValueAllocator = new ListObjectPool<AFlatValuePointable, IAType>(AFlatValuePointable.FACTORY);
    private IObjectPool<ARecordVisitablePointable, IAType> recordValueAllocator = new ListObjectPool<ARecordVisitablePointable, IAType>(ARecordVisitablePointable.FACTORY);
    private IObjectPool<AListVisitablePointable, IAType> listValueAllocator = new ListObjectPool<AListVisitablePointable, IAType>(AListVisitablePointable.FACTORY);
    private IObjectPool<AOrderedListType, IAType> orederedListTypeAllocator = new ListObjectPool<AOrderedListType, IAType>(new IObjectFactory<AOrderedListType, IAType>(){

        @Override
        public AOrderedListType create(IAType type) {
            return new AOrderedListType(type, type.getTypeName() + "OrderedList");
        }
    });
    private IObjectPool<AOrderedListType, IAType> unorederedListTypeAllocator = new ListObjectPool<AOrderedListType, IAType>(new IObjectFactory<AOrderedListType, IAType>(){

        @Override
        public AOrderedListType create(IAType type) {
            return new AOrderedListType(type, type.getTypeName() + "UnorderedList");
        }
    });

    public IVisitablePointable allocateEmpty() {
        return this.flatValueAllocator.allocate(null);
    }

    public static IVisitablePointable allocateUnrestableEmpty() {
        return AFlatValuePointable.FACTORY.create(null);
    }

    public IVisitablePointable allocateFieldValue(IAType type) {
        if (type == null) {
            return this.flatValueAllocator.allocate(null);
        }
        if (type.getTypeTag().equals(ATypeTag.OBJECT)) {
            return this.recordValueAllocator.allocate(type);
        }
        if (type.getTypeTag().equals(ATypeTag.MULTISET) || type.getTypeTag().equals(ATypeTag.ARRAY)) {
            return this.listValueAllocator.allocate(type);
        }
        return this.flatValueAllocator.allocate(null);
    }

    public IVisitablePointable allocateFieldValue(ATypeTag typeTag, byte[] b, int offset) throws HyracksDataException {
        if (typeTag == null) {
            return this.flatValueAllocator.allocate(null);
        }
        if (typeTag.equals(ATypeTag.OBJECT)) {
            return this.recordValueAllocator.allocate(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        }
        if (typeTag.equals(ATypeTag.MULTISET)) {
            ATypeTag listItemType = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(b[offset]);
            if (listItemType == ATypeTag.ANY) {
                return this.listValueAllocator.allocate(DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE);
            }
            if (listItemType.isDerivedType()) {
                return this.allocateFieldValue(listItemType, b, offset + 1);
            }
            return this.listValueAllocator.allocate(this.unorederedListTypeAllocator.allocate(TypeTagUtil.getBuiltinTypeByTag(listItemType)));
        }
        if (typeTag.equals(ATypeTag.ARRAY)) {
            ATypeTag listItemType = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(b[offset]);
            if (listItemType == ATypeTag.ANY) {
                return this.listValueAllocator.allocate(DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
            }
            if (listItemType.isDerivedType()) {
                return this.allocateFieldValue(listItemType, b, offset + 1);
            }
            return this.listValueAllocator.allocate(this.orederedListTypeAllocator.allocate(TypeTagUtil.getBuiltinTypeByTag(listItemType)));
        }
        return this.flatValueAllocator.allocate(null);
    }

    public AListVisitablePointable allocateListValue(IAType type) {
        return this.listValueAllocator.allocate(type);
    }

    public ARecordVisitablePointable allocateRecordValue(IAType type) {
        return this.recordValueAllocator.allocate(type);
    }

    public void reset() {
        this.flatValueAllocator.reset();
        this.recordValueAllocator.reset();
        this.listValueAllocator.reset();
    }
}

