/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.functions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class FunctionInfoRepository {
    private final Map<FunctionSignature, IFunctionInfo> functionMap = new ConcurrentHashMap<FunctionSignature, IFunctionInfo>();

    public IFunctionInfo get(String namespace, String name, int arity) {
        FunctionSignature functionSignature = new FunctionSignature(namespace, name, arity);
        return this.functionMap.get(functionSignature);
    }

    public IFunctionInfo get(FunctionIdentifier fid) {
        return this.get(fid.getNamespace(), fid.getName(), fid.getArity());
    }

    public void put(FunctionIdentifier fid, IFunctionInfo fInfo) {
        FunctionSignature functionSignature = new FunctionSignature(fid);
        this.functionMap.put(functionSignature, fInfo);
    }
}

