/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.object.base;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.object.base.AdmNullNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class AdmObjectNode
implements IAdmNode {
    private static final long serialVersionUID = 1L;
    public static final AdmObjectNode EMPTY = new AdmObjectNode(Collections.emptyMap());
    private final Map<String, IAdmNode> children;

    public AdmObjectNode() {
        this.children = new HashMap<String, IAdmNode>();
    }

    public AdmObjectNode(Map<String, IAdmNode> children) {
        this.children = children;
    }

    @Override
    public ATypeTag getType() {
        return ATypeTag.OBJECT;
    }

    public int size() {
        return this.children.size();
    }

    public IAdmNode get(String fieldName) {
        return this.children.get(fieldName);
    }

    public Set<String> getFieldNames() {
        return this.children.keySet();
    }

    public Set<Map.Entry<String, IAdmNode>> getFields() {
        return this.children.entrySet();
    }

    public AdmObjectNode set(String fieldName, IAdmNode value) throws CompilationException {
        if (value == null) {
            value = AdmNullNode.INSTANCE;
        }
        if (this.children.containsKey(fieldName)) {
            throw new CompilationException(13, new Serializable[]{fieldName});
        }
        this.children.put(fieldName, value);
        return this;
    }

    public IAdmNode remove(String fieldName) {
        return this.children.remove(fieldName);
    }

    @Override
    public void reset() {
        this.children.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int count = 0;
        for (Map.Entry<String, IAdmNode> en : this.children.entrySet()) {
            if (count > 0) {
                sb.append(",");
            }
            ++count;
            sb.append('\"');
            sb.append(en.getKey());
            sb.append('\"');
            sb.append(':');
            sb.append(en.getValue().toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static AdmObjectNode from(Map<String, IAdmNode> fields) {
        return fields.isEmpty() ? EMPTY : new AdmObjectNode(fields);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public void serializeValue(DataOutput dataOutput) throws IOException {
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(BuiltinType.ASTRING);
        RecordBuilder confRecordBuilder = new RecordBuilder();
        confRecordBuilder.reset(RecordUtil.FULLY_OPEN_RECORD_TYPE);
        confRecordBuilder.init();
        ArrayBackedValueStorage fieldNameBytes = new ArrayBackedValueStorage();
        ArrayBackedValueStorage fieldValueBytes = new ArrayBackedValueStorage();
        for (Map.Entry<String, IAdmNode> field : this.getFields()) {
            String fieldName = field.getKey();
            fieldValueBytes.reset();
            fieldNameBytes.reset();
            stringSerde.serialize((Object)new AString(fieldName), fieldNameBytes.getDataOutput());
            IAdmNode value = field.getValue();
            value.serialize(fieldValueBytes.getDataOutput());
            confRecordBuilder.addField((IValueReference)fieldNameBytes, (IValueReference)fieldValueBytes);
        }
        confRecordBuilder.write(dataOutput, false);
    }

    public boolean contains(String fieldName) {
        return this.children.containsKey(fieldName);
    }

    public String getString(String field) throws HyracksDataException {
        return AdmObjectNode.getString(this, field);
    }

    public static String getString(AdmObjectNode openFields, String field) throws HyracksDataException {
        IAdmNode node = openFields.get(field);
        if (node == null) {
            throw HyracksDataException.create((int)1088, (Serializable[])new Serializable[]{field});
        }
        if (node.getType() != ATypeTag.STRING) {
            throw HyracksDataException.create((int)1089, (Serializable[])new Serializable[]{field, ATypeTag.STRING, node.getType()});
        }
        return ((AdmStringNode)node).get();
    }
}

