/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;
import org.apache.hyracks.data.std.primitive.VarLengthTypeTrait;

public class TypeTraitProvider
implements ITypeTraitProvider {
    private static final ITypeTraits ONEBYTETYPETRAIT = new FixedLengthTypeTrait(2);
    private static final ITypeTraits TWOBYTETYPETRAIT = new FixedLengthTypeTrait(3);
    private static final ITypeTraits FOURBYTETYPETRAIT = new FixedLengthTypeTrait(5);
    private static final ITypeTraits EIGHTBYTETYPETRAIT = new FixedLengthTypeTrait(9);
    private static final ITypeTraits SIXTEENBYTETYPETRAIT = new FixedLengthTypeTrait(17);
    private static final ITypeTraits SEVENTEENBYTETYPETRAIT = new FixedLengthTypeTrait(18);
    private static final ITypeTraits THIRTYTWOBYTETYPETRAIT = new FixedLengthTypeTrait(33);
    private static final ITypeTraits TWENTYFOURBYTETYPETRAIT = new FixedLengthTypeTrait(25);
    private static final ITypeTraits VARLENTYPETRAIT = VarLengthTypeTrait.INSTANCE;
    public static final TypeTraitProvider INSTANCE = new TypeTraitProvider();

    public ITypeTraits getTypeTrait(Object type) {
        IAType aqlType = (IAType)type;
        if (aqlType == null) {
            return null;
        }
        switch (aqlType.getTypeTag()) {
            case BOOLEAN: 
            case TINYINT: {
                return ONEBYTETYPETRAIT;
            }
            case SMALLINT: {
                return TWOBYTETYPETRAIT;
            }
            case INTEGER: 
            case FLOAT: 
            case DATE: 
            case TIME: {
                return FOURBYTETYPETRAIT;
            }
            case BIGINT: 
            case DOUBLE: 
            case DATETIME: 
            case DURATION: {
                return EIGHTBYTETYPETRAIT;
            }
            case POINT: 
            case UUID: {
                return SIXTEENBYTETYPETRAIT;
            }
            case INTERVAL: {
                return SEVENTEENBYTETYPETRAIT;
            }
            case POINT3D: {
                return TWENTYFOURBYTETYPETRAIT;
            }
            case LINE: {
                return THIRTYTWOBYTETYPETRAIT;
            }
        }
        return VARLENTYPETRAIT;
    }
}

