/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class BooleanBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    public static final BooleanBinaryComparatorFactory INSTANCE = new BooleanBinaryComparatorFactory();

    private BooleanBinaryComparatorFactory() {
    }

    public IBinaryComparator createBinaryComparator() {
        return new IBinaryComparator(){

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                boolean v1 = ABooleanSerializerDeserializer.getBoolean(b1, s1);
                boolean v2 = ABooleanSerializerDeserializer.getBoolean(b2, s2);
                if (v1) {
                    return v2 ? 0 : 1;
                }
                return v2 ? -1 : 0;
            }
        };
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        return registry.getClassIdentifier(this.getClass(), 1L);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return INSTANCE;
    }
}

