/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.asterix.dataflow.data.nontagged.comparators.ABinaryComparator;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalDescPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectAscBinaryComparatorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class AObjectDescBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    public static final IBinaryComparatorFactory INSTANCE = new AObjectDescBinaryComparatorFactory();

    private AObjectDescBinaryComparatorFactory() {
    }

    public IBinaryComparator createBinaryComparator() {
        return new ABinaryComparator(){
            final IBinaryComparator ascComp = AObjectAscBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator descIntervalComp = AIntervalDescPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();

            @Override
            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                ATypeTag tag1 = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(b1[s1]);
                ATypeTag tag2 = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(b2[s2]);
                if (tag1 == ATypeTag.INTERVAL && tag2 == ATypeTag.INTERVAL) {
                    return this.descIntervalComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                }
                return -this.ascComp.compare(b1, s1, l1, b2, s2, l2);
            }
        };
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        return registry.getClassIdentifier(this.getClass(), 1L);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return INSTANCE;
    }
}

