/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.result;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.partitions.ResultSetPartitionId;
import org.apache.hyracks.api.result.IResultPartitionManager;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.nc.result.ResultMemoryManager;
import org.apache.hyracks.control.nc.result.ResultState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultPartitionWriter
implements IFrameWriter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IResultPartitionManager manager;
    private final JobId jobId;
    private final ResultSetId resultSetId;
    private final boolean orderedResult;
    private final int partition;
    private final int nPartitions;
    private final ResultMemoryManager resultMemoryManager;
    private final ResultSetPartitionId resultSetPartitionId;
    private final ResultState resultState;
    private boolean partitionRegistered;
    private boolean failed = false;

    public ResultPartitionWriter(IHyracksTaskContext ctx, IResultPartitionManager manager, JobId jobId, ResultSetId rsId, boolean asyncMode, boolean orderedResult, int partition, int nPartitions, ResultMemoryManager resultMemoryManager, IWorkspaceFileFactory fileFactory, long maxReads) {
        this.manager = manager;
        this.jobId = jobId;
        this.resultSetId = rsId;
        this.orderedResult = orderedResult;
        this.partition = partition;
        this.nPartitions = nPartitions;
        this.resultMemoryManager = resultMemoryManager;
        this.resultSetPartitionId = new ResultSetPartitionId(jobId, rsId, partition);
        this.resultState = new ResultState(this.resultSetPartitionId, asyncMode, ctx.getIoManager(), fileFactory, ctx.getInitialFrameSize(), maxReads);
    }

    public ResultState getResultState() {
        return this.resultState;
    }

    public void open() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("open(" + this.partition + ")");
        }
        this.partitionRegistered = false;
        this.resultState.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.registerResultPartitionLocation(false);
        if (this.resultMemoryManager == null) {
            this.resultState.write(buffer);
        } else {
            this.resultState.write(this.resultMemoryManager, buffer);
        }
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        this.resultState.closeAndDelete();
        this.resultState.abort();
    }

    public void close() throws HyracksDataException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("close(" + this.partition + ")");
        }
        try {
            if (!this.failed) {
                this.registerResultPartitionLocation(true);
            }
        }
        finally {
            this.resultState.close();
        }
        try {
            if (this.partitionRegistered) {
                this.manager.reportPartitionWriteCompletion(this.jobId, this.resultSetId, this.partition);
            }
        }
        catch (HyracksException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    void registerResultPartitionLocation(boolean empty) throws HyracksDataException {
        try {
            if (!this.partitionRegistered) {
                this.manager.registerResultPartitionLocation(this.jobId, this.resultSetId, this.partition, this.nPartitions, this.orderedResult, empty);
                this.partitionRegistered = true;
            }
        }
        catch (HyracksException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

