/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.comm.ICloseableBufferAcceptor;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.net.protocols.muxdemux.ChannelControlBlock;
import org.apache.hyracks.net.protocols.muxdemux.IChannelOpenListener;
import org.apache.hyracks.net.protocols.muxdemux.MultiplexedConnection;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemux;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagingNetworkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    private final MuxDemux md;
    private NetworkAddress localNetworkAddress;
    private NetworkAddress publicNetworkAddress;
    private final Map<String, IChannelControlBlock> ncChannels = new HashMap<String, IChannelControlBlock>();
    private final NodeControllerService ncs;
    private final Map<IChannelControlBlock, ICloseableBufferAcceptor> channelFullBufferAcceptor = new HashMap<IChannelControlBlock, ICloseableBufferAcceptor>();

    public MessagingNetworkManager(NodeControllerService ncs, String inetAddress, int inetPort, int nThreads, String publicInetAddress, int publicInetPort, IChannelInterfaceFactory channelInterfaceFactory) {
        this.ncs = ncs;
        this.md = new MuxDemux(new InetSocketAddress(inetAddress, inetPort), (IChannelOpenListener)new ChannelOpenListener(), nThreads, 5, channelInterfaceFactory);
        this.publicNetworkAddress = new NetworkAddress(publicInetAddress, publicInetPort);
    }

    public void start() throws IOException {
        this.md.start();
        InetSocketAddress sockAddr = this.md.getLocalAddress();
        this.localNetworkAddress = new NetworkAddress(sockAddr.getHostString(), sockAddr.getPort());
        if (this.publicNetworkAddress.getAddress() == null) {
            this.publicNetworkAddress = this.localNetworkAddress;
        } else if (this.publicNetworkAddress.getPort() == 0) {
            this.publicNetworkAddress = new NetworkAddress(this.publicNetworkAddress.getAddress(), sockAddr.getPort());
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChannelControlBlock getMessagingChannel(String nodeId) throws Exception {
        Map<String, IChannelControlBlock> map = this.ncChannels;
        synchronized (map) {
            IChannelControlBlock ccb = this.ncChannels.get(nodeId);
            if (ccb == null) {
                ccb = this.establishNewConnection(nodeId);
                this.addOpenChannel(nodeId, ccb);
            }
            return ccb;
        }
    }

    private ChannelControlBlock connect(SocketAddress remoteAddress) throws InterruptedException, NetException {
        MultiplexedConnection mConn = this.md.connect((InetSocketAddress)remoteAddress);
        return mConn.openChannel();
    }

    public MuxDemuxPerformanceCounters getPerformanceCounters() {
        return this.md.getPerformanceCounters();
    }

    public NetworkAddress getPublicNetworkAddress() {
        return this.publicNetworkAddress;
    }

    private void prepareMessagingInitialMessage(String ncId, ByteBuffer buffer) throws NetException {
        int intialMsgLength = 4 + ncId.length();
        if (intialMsgLength > buffer.capacity()) {
            throw new NetException("Initial message exceded the channel buffer size " + buffer.capacity() + " bytes");
        }
        buffer.clear();
        buffer.putInt(ncId.length());
        buffer.put(ncId.getBytes());
        buffer.flip();
    }

    private IChannelControlBlock establishNewConnection(String nodeId) throws Exception {
        Map<String, NodeControllerInfo> nodeControllers = this.ncs.getNodeControllersInfo();
        NodeControllerInfo nodeControllerInfo = nodeControllers.get(nodeId);
        if (nodeControllerInfo == null) {
            throw new NetException("Could not find node: " + nodeId);
        }
        NetworkAddress nodeMessagingNeAddress = nodeControllerInfo.getMessagingNetworkAddress();
        InetSocketAddress nodeAddress = new InetSocketAddress(InetAddress.getByName(nodeMessagingNeAddress.getAddress()), nodeMessagingNeAddress.getPort());
        ChannelControlBlock ccb = this.connect(nodeAddress);
        try {
            ByteBuffer initialBuffer = ccb.getReadInterface().getBufferFactory().createBuffer();
            this.prepareMessagingInitialMessage(this.ncs.getId(), initialBuffer);
            ccb.getWriteInterface().getFullBufferAcceptor().accept(initialBuffer);
            return ccb;
        }
        catch (NetException e) {
            this.closeChannel((IChannelControlBlock)ccb);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpenChannel(String nodeId, IChannelControlBlock ccb) {
        Map<String, IChannelControlBlock> map = this.ncChannels;
        synchronized (map) {
            if (this.ncChannels.get(nodeId) == null) {
                this.ncChannels.put(nodeId, ccb);
            } else {
                this.closeChannel(ccb);
            }
        }
    }

    private void closeChannel(IChannelControlBlock ccb) {
        ccb.getWriteInterface().getFullBufferAcceptor().close();
    }

    private class InitialBufferAcceptor
    implements ICloseableBufferAcceptor {
        private final ChannelControlBlock ccb;

        public InitialBufferAcceptor(ChannelControlBlock ccb) {
            this.ccb = ccb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(ByteBuffer buffer) {
            ICloseableBufferAcceptor originalAcceptor;
            String nodeId = this.readMessagingInitialMessage(buffer);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Opened messaging channel with node: " + nodeId);
            }
            Map map = MessagingNetworkManager.this.channelFullBufferAcceptor;
            synchronized (map) {
                originalAcceptor = (ICloseableBufferAcceptor)MessagingNetworkManager.this.channelFullBufferAcceptor.remove(this.ccb);
                if (originalAcceptor == null) {
                    throw new IllegalStateException("Could not find channel acceptor");
                }
            }
            this.ccb.getReadInterface().setFullBufferAcceptor(originalAcceptor);
            MessagingNetworkManager.this.addOpenChannel(nodeId, (IChannelControlBlock)this.ccb);
        }

        public void close() {
        }

        public void error(int ecode) {
        }

        private String readMessagingInitialMessage(ByteBuffer buffer) {
            int nodeIdLength = buffer.getInt();
            byte[] stringBytes = new byte[nodeIdLength];
            buffer.get(stringBytes);
            return new String(stringBytes);
        }
    }

    private class ChannelOpenListener
    implements IChannelOpenListener {
        private ChannelOpenListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelOpened(ChannelControlBlock channel) {
            ICloseableBufferAcceptor fullBufferAcceptor = channel.getReadInterface().getFullBufferAcceptor();
            Map map = MessagingNetworkManager.this.channelFullBufferAcceptor;
            synchronized (map) {
                MessagingNetworkManager.this.channelFullBufferAcceptor.put(channel, fullBufferAcceptor);
            }
            channel.getReadInterface().setFullBufferAcceptor((ICloseableBufferAcceptor)new InitialBufferAcceptor(channel));
        }
    }
}

