/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.net.URI;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

public class NCLogConfigurationFactory
extends ConfigurationFactory {
    private NCConfig config;

    public NCLogConfigurationFactory(NCConfig config) {
        this.config = config;
    }

    public Configuration createConfiguration(ConfigurationBuilder<BuiltConfiguration> builder) {
        String nodeId = this.config.getNodeId();
        String logDir = this.config.getLogDir();
        builder.setStatusLevel(Level.WARN);
        builder.setConfigurationName("RollingBuilder");
        LayoutComponentBuilder defaultLayout = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d{HH:mm:ss.SSS} [%t] %-5level %logger{36} - %msg%n");
        ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("CronTriggeringPolicy").addAttribute("schedule", "0 0 0 * * ?")).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "50M"));
        AppenderComponentBuilder defaultRoll = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("default", "RollingFile").addAttribute("fileName", logDir + "nc-" + nodeId + ".log")).addAttribute("filePattern", logDir + "nc-" + nodeId + "-%d{MM-dd-yy}.log.gz")).add(defaultLayout).addComponent(triggeringPolicy);
        builder.add(defaultRoll);
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(builder.newAppenderRef("default")));
        LayoutComponentBuilder accessLayout = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%m%n");
        AppenderComponentBuilder accessRoll = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("access", "RollingFile").addAttribute("fileName", logDir + "access-" + nodeId + ".log")).addAttribute("filePattern", logDir + "access-" + nodeId + "-%d{MM-dd-yy}.log.gz")).add(accessLayout).addComponent(triggeringPolicy);
        builder.add(accessRoll);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.hyracks.http.server.CLFLogger", Level.forName((String)"ACCESS", (int)550)).add(builder.newAppenderRef("access"))).addAttribute("additivity", false));
        return (Configuration)builder.build();
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        ConfigurationBuilder builder = NCLogConfigurationFactory.newConfigurationBuilder();
        return this.createConfiguration((ConfigurationBuilder<BuiltConfiguration>)builder);
    }

    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    public String toString() {
        return "NCLogConfiguration";
    }
}

