/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.util.Map;
import org.apache.asterix.external.feed.management.FeedConnectionRequest;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class CompiledStatements {

    public static class CompiledIndexCompactStatement
    extends CompiledCompactStatement {
        private Dataset dataset;
        private Index index;

        public CompiledIndexCompactStatement(Dataset dataset, Index index) {
            super(dataset.getDataverseName(), dataset.getDatasetName());
            this.dataset = dataset;
            this.index = index;
        }

        public Dataset getDataset() {
            return this.dataset;
        }

        public Index getIndex() {
            return this.index;
        }
    }

    public static class CompiledCompactStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final String datasetName;

        public CompiledCompactStatement(String dataverseName, String datasetName) {
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.COMPACT;
        }
    }

    public static class CompiledDeleteStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final String dataverseName;
        private final String datasetName;
        private final Expression condition;
        private final int varCounter;
        private final Query query;

        public CompiledDeleteStatement(VariableExpr var, String dataverseName, String datasetName, Expression condition, int varCounter, Query query) {
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.condition = condition;
            this.varCounter = varCounter;
            this.query = query;
        }

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public String getDataverseName() {
            return this.dataverseName;
        }

        public int getVarCounter() {
            return this.varCounter;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public Query getQuery() throws AlgebricksException {
            return this.query;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.DELETE;
        }
    }

    public static class CompiledSubscribeFeedStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private FeedConnectionRequest request;
        private final int varCounter;

        public CompiledSubscribeFeedStatement(FeedConnectionRequest request, int varCounter) {
            this.request = request;
            this.varCounter = varCounter;
        }

        @Override
        public String getDataverseName() {
            return this.request.getReceivingFeedId().getDataverse();
        }

        public String getFeedName() {
            return this.request.getReceivingFeedId().getEntityName();
        }

        @Override
        public String getDatasetName() {
            return this.request.getTargetDataset();
        }

        public int getVarCounter() {
            return this.varCounter;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.SUBSCRIBE_FEED;
        }
    }

    public static class CompiledUpsertStatement
    extends CompiledInsertStatement {
        public CompiledUpsertStatement(String dataverseName, String datasetName, Query query, int varCounter, VariableExpr var, Expression returnExpression) {
            super(dataverseName, datasetName, query, varCounter, var, returnExpression);
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.UPSERT;
        }
    }

    public static class CompiledInsertStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final String dataverseName;
        private final String datasetName;
        private final Query query;
        private final int varCounter;
        private final VariableExpr var;
        private final Expression returnExpression;

        public CompiledInsertStatement(String dataverseName, String datasetName, Query query, int varCounter, VariableExpr var, Expression returnExpression) {
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.query = query;
            this.varCounter = varCounter;
            this.var = var;
            this.returnExpression = returnExpression;
        }

        @Override
        public String getDataverseName() {
            return this.dataverseName;
        }

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        public int getVarCounter() {
            return this.varCounter;
        }

        public Query getQuery() {
            return this.query;
        }

        public VariableExpr getVar() {
            return this.var;
        }

        public Expression getReturnExpression() {
            return this.returnExpression;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.INSERT;
        }
    }

    public static class CompiledLoadFromFileStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final String dataverseName;
        private final String datasetName;
        private final boolean alreadySorted;
        private final String adapter;
        private final Map<String, String> properties;

        public CompiledLoadFromFileStatement(String dataverseName, String datasetName, String adapter, Map<String, String> properties, boolean alreadySorted) {
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.alreadySorted = alreadySorted;
            this.adapter = adapter;
            this.properties = properties;
        }

        @Override
        public String getDataverseName() {
            return this.dataverseName;
        }

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        public boolean alreadySorted() {
            return this.alreadySorted;
        }

        public String getAdapter() {
            return this.adapter;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.LOAD;
        }
    }

    public static class CompiledCreateIndexStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final Dataset dataset;
        private final Index index;

        public CompiledCreateIndexStatement(Dataset dataset, Index index) {
            this.dataset = dataset;
            this.index = index;
        }

        @Override
        public String getDatasetName() {
            return this.index.getDatasetName();
        }

        @Override
        public String getDataverseName() {
            return this.index.getDataverseName();
        }

        public Index getIndex() {
            return this.index;
        }

        public Dataset getDataset() {
            return this.dataset;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.CREATE_INDEX;
        }
    }

    public static interface ICompiledDmlStatement
    extends ICompiledStatement {
        public String getDataverseName();

        public String getDatasetName();
    }

    public static class CompiledTypeDropStatement
    extends AbstractCompiledStatement {
        private final String typeName;

        public CompiledTypeDropStatement(String nodeGroupName) {
            this.typeName = nodeGroupName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.TYPE_DROP;
        }
    }

    public static class CompiledDataverseDropStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final boolean ifExists;

        public CompiledDataverseDropStatement(String dataverseName, boolean ifExists) {
            this.dataverseName = dataverseName;
            this.ifExists = ifExists;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public boolean getIfExists() {
            return this.ifExists;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.DATAVERSE_DROP;
        }
    }

    public static class CompiledIndexDropStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final String datasetName;
        private final String indexName;

        public CompiledIndexDropStatement(String dataverseName, String datasetName, String indexName) {
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.indexName = indexName;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.INDEX_DROP;
        }
    }

    public static class CompiledNodeGroupDropStatement
    extends AbstractCompiledStatement {
        private final String nodeGroupName;

        public CompiledNodeGroupDropStatement(String nodeGroupName) {
            this.nodeGroupName = nodeGroupName;
        }

        public String getNodeGroupName() {
            return this.nodeGroupName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.NODEGROUP_DROP;
        }
    }

    public static class CompiledCreateDataverseStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final String format;

        public CompiledCreateDataverseStatement(String dataverseName, String format) {
            this.dataverseName = dataverseName;
            this.format = format;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public String getFormat() {
            return this.format;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.CREATE_DATAVERSE;
        }
    }

    public static class CompiledDatasetDropStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final String datasetName;

        public CompiledDatasetDropStatement(String dataverseName, String datasetName) {
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.DATASET_DROP;
        }
    }

    public static abstract class AbstractCompiledStatement
    implements ICompiledStatement {
        private SourceLocation sourceLoc;

        public void setSourceLocation(SourceLocation sourceLoc) {
            this.sourceLoc = sourceLoc;
        }

        @Override
        public SourceLocation getSourceLocation() {
            return this.sourceLoc;
        }
    }

    public static interface ICompiledStatement {
        public Statement.Kind getKind();

        public SourceLocation getSourceLocation();
    }
}

