/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.dataflow.data.common.TypeResolverUtil;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class InjectTypeCastForUnionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.UNIONALL) {
            return false;
        }
        UnionAllOperator unionAllOperator = (UnionAllOperator)op;
        return this.injectCast(unionAllOperator, 0, context) || this.injectCast(unionAllOperator, 1, context);
    }

    private boolean injectCast(UnionAllOperator op, int childIndex, IOptimizationContext context) throws AlgebricksException {
        IVariableTypeEnvironment env = context.getOutputTypeEnvironment((ILogicalOperator)op);
        Mutable branchOpRef = (Mutable)op.getInputs().get(childIndex);
        ILogicalOperator branchOp = (ILogicalOperator)branchOpRef.getValue();
        IVariableTypeEnvironment childEnv = context.getOutputTypeEnvironment(branchOp);
        SourceLocation sourceLoc = branchOp.getSourceLocation();
        ArrayList<LogicalVariable> varsToCast = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> castFunctionsForLeft = new ArrayList<MutableObject>();
        List triples = op.getVariableMappings();
        for (Triple triple : triples) {
            LogicalVariable varToCast;
            IAType inputType;
            LogicalVariable producedVar = (LogicalVariable)triple.third;
            IAType producedType = (IAType)env.getVarType(producedVar);
            if (!TypeResolverUtil.needsCast((IAType)producedType, (IAType)(inputType = (IAType)childEnv.getVarType(varToCast = childIndex == 0 ? (LogicalVariable)triple.first : (LogicalVariable)triple.second)))) continue;
            LogicalVariable castedVar = context.newVar();
            triple.first = childIndex == 0 ? castedVar : (LogicalVariable)triple.first;
            triple.second = childIndex > 0 ? castedVar : (LogicalVariable)triple.second;
            VariableReferenceExpression varToCastRef = new VariableReferenceExpression(varToCast);
            varToCastRef.setSourceLocation(sourceLoc);
            ScalarFunctionCallExpression castFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE), new ArrayList<MutableObject>(Collections.singletonList(new MutableObject((Object)varToCastRef))));
            castFunc.setSourceLocation(sourceLoc);
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)castFunc, (IAType)producedType, (IAType)inputType);
            varsToCast.add(castedVar);
            castFunctionsForLeft.add(new MutableObject((Object)castFunc));
        }
        if (castFunctionsForLeft.isEmpty()) {
            return false;
        }
        AssignOperator assignOp = new AssignOperator(varsToCast, castFunctionsForLeft);
        assignOp.setSourceLocation(sourceLoc);
        assignOp.setExecutionMode(branchOp.getExecutionMode());
        assignOp.getInputs().add(new MutableObject((Object)branchOp));
        branchOpRef.setValue((Object)assignOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        return true;
    }
}

