/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class CountVarToCountOneRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator g = (GroupByOperator)op1;
        if (g.getNestedPlans().size() != 1) {
            return false;
        }
        ILogicalPlan p = (ILogicalPlan)g.getNestedPlans().get(0);
        if (p.getRoots().size() != 1) {
            return false;
        }
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)p.getRoots().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator agg = (AggregateOperator)op2;
        if (agg.getExpressions().size() != 1) {
            return false;
        }
        ILogicalExpression exp2 = (ILogicalExpression)((Mutable)agg.getExpressions().get(0)).getValue();
        if (exp2.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression fun = (AbstractFunctionCallExpression)exp2;
        if (fun.getFunctionIdentifier() != BuiltinFunctions.COUNT) {
            return false;
        }
        ILogicalExpression exp3 = (ILogicalExpression)((Mutable)fun.getArguments().get(0)).getValue();
        if (exp3.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        if (((ILogicalOperator)((Mutable)agg.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return false;
        }
        ((Mutable)fun.getArguments().get(0)).setValue((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt64(1L))));
        return true;
    }
}

