/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;

public final class ShortPointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    public static final ITypeTraits TYPE_TRAITS = new FixedLengthTypeTrait(2);
    public static final IPointableFactory FACTORY = new ShortPointableFactory();

    public static short getShort(byte[] bytes, int start) {
        return (short)(((bytes[start] & 0xFF) << 8) + (bytes[start + 1] & 0xFF));
    }

    public static void setShort(byte[] bytes, int start, short value) {
        bytes[start] = (byte)(value >>> 8 & 0xFF);
        bytes[start + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public short getShort() {
        return ShortPointable.getShort(this.bytes, this.start);
    }

    public void setShort(short value) {
        ShortPointable.setShort(this.bytes, this.start, value);
    }

    public short preIncrement() {
        short v = this.getShort();
        v = (short)(v + 1);
        this.setShort(v);
        return v;
    }

    public short postIncrement() {
        short v;
        short s = v = this.getShort();
        v = (short)(v + 1);
        short ov = s;
        this.setShort(v);
        return ov;
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        short ov;
        short v = this.getShort();
        return v < (ov = ShortPointable.getShort(bytes, start)) ? -1 : (v > ov ? 1 : 0);
    }

    @Override
    public int hash() {
        return this.getShort();
    }

    @Override
    public byte byteValue() {
        return (byte)this.getShort();
    }

    @Override
    public short shortValue() {
        return this.getShort();
    }

    @Override
    public int intValue() {
        return this.getShort();
    }

    @Override
    public long longValue() {
        return this.getShort();
    }

    @Override
    public float floatValue() {
        return this.getShort();
    }

    @Override
    public double doubleValue() {
        return this.getShort();
    }

    public static final class ShortPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new ShortPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

