/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;

public final class IntegerPointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    public static final IntegerPointableFactory FACTORY = new IntegerPointableFactory();
    public static final ITypeTraits TYPE_TRAITS = new FixedLengthTypeTrait(4){
        private static final long serialVersionUID = -7178318032449879790L;

        @Override
        public boolean isFixedLength() {
            return super.isFixedLength();
        }
    };

    public static int getInteger(byte[] bytes, int start) {
        return ((bytes[start] & 0xFF) << 24) + ((bytes[start + 1] & 0xFF) << 16) + ((bytes[start + 2] & 0xFF) << 8) + ((bytes[start + 3] & 0xFF) << 0);
    }

    public static void setInteger(byte[] bytes, int start, int value) {
        bytes[start] = (byte)(value >>> 24 & 0xFF);
        bytes[start + 1] = (byte)(value >>> 16 & 0xFF);
        bytes[start + 2] = (byte)(value >>> 8 & 0xFF);
        bytes[start + 3] = (byte)(value >>> 0 & 0xFF);
    }

    public int getInteger() {
        return IntegerPointable.getInteger(this.bytes, this.start);
    }

    public void setInteger(int value) {
        IntegerPointable.setInteger(this.bytes, this.start, value);
    }

    public int preIncrement() {
        int v = this.getInteger();
        this.setInteger(++v);
        return v;
    }

    public int postIncrement() {
        int v = this.getInteger();
        int ov = v++;
        this.setInteger(v);
        return ov;
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        int ov;
        int v = this.getInteger();
        return v < (ov = IntegerPointable.getInteger(bytes, start)) ? -1 : (v > ov ? 1 : 0);
    }

    @Override
    public int hash() {
        return this.getInteger();
    }

    @Override
    public byte byteValue() {
        return (byte)this.getInteger();
    }

    @Override
    public short shortValue() {
        return (short)this.getInteger();
    }

    @Override
    public int intValue() {
        return this.getInteger();
    }

    @Override
    public long longValue() {
        return this.getInteger();
    }

    @Override
    public float floatValue() {
        return this.getInteger();
    }

    @Override
    public double doubleValue() {
        return this.getInteger();
    }

    public static final class IntegerPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public IntegerPointable createPointable() {
            return new IntegerPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

