/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.accessors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;

public class PointableBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    protected final IPointableFactory pf;

    public static PointableBinaryComparatorFactory of(IPointableFactory pf) {
        return new PointableBinaryComparatorFactory(pf);
    }

    public PointableBinaryComparatorFactory(IPointableFactory pf) {
        this.pf = pf;
    }

    public IBinaryComparator createBinaryComparator() {
        final IPointable p = this.pf.createPointable();
        return new IBinaryComparator(){

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                if (l1 == 0 && l2 != 0) {
                    return -1;
                }
                if (l1 != 0 && l2 == 0) {
                    return 1;
                }
                p.set(b1, s1, l1);
                return ((IComparable)((Object)p)).compareTo(b2, s2, l2);
            }
        };
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode classIdentifier = registry.getClassIdentifier(this.getClass(), 1L);
        classIdentifier.set("pointableFactory", this.pf.toJson(registry));
        return classIdentifier;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        IPointableFactory pointableFactory = (IPointableFactory)registry.deserialize(json.get("pointableFactory"));
        return PointableBinaryComparatorFactory.of(pointableFactory);
    }
}

