/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class TypeUtil {
    private TypeUtil() {
    }

    public static Pair<ARecordType, ARecordType> createEnforcedType(ARecordType recordType, ARecordType metaType, List<Index> indexes) throws AlgebricksException {
        ARecordType enforcedRecordType = recordType;
        ARecordType enforcedMetaType = metaType;
        for (Index index : indexes) {
            if (!index.isSecondaryIndex() || !index.isOverridingKeyFieldTypes()) continue;
            if (index.hasMetaFields()) {
                throw new AlgebricksException("Indexing an open field is only supported on the record part");
            }
            for (int i = 0; i < index.getKeyFieldNames().size(); ++i) {
                int j;
                ArrayDeque<Pair> nestedTypeStack = new ArrayDeque<Pair>();
                List<String> splits = index.getKeyFieldNames().get(i);
                ARecordType nestedFieldType = enforcedRecordType;
                boolean openRecords = false;
                String bridgeName = nestedFieldType.getTypeName();
                TypeUtil.validateRecord((IAType)enforcedRecordType);
                for (j = 1; j < splits.size(); ++j) {
                    nestedTypeStack.push(new Pair((Object)nestedFieldType, (Object)splits.get(j - 1)));
                    bridgeName = nestedFieldType.getTypeName();
                    List<String> subFieldName = splits.subList(0, j);
                    nestedFieldType = enforcedRecordType.getSubFieldType(subFieldName);
                    if (nestedFieldType == null) {
                        openRecords = true;
                        break;
                    }
                    TypeUtil.validateNestedRecord((IAType)nestedFieldType, subFieldName);
                }
                if (openRecords) {
                    enforcedRecordType = new ARecordType(splits.get(splits.size() - 2), new String[]{splits.get(splits.size() - 1)}, new IAType[]{AUnionType.createUnknownableType((IAType)index.getKeyFieldTypes().get(i))}, true);
                    for (int k = splits.size() - 3; k > j - 2; --k) {
                        enforcedRecordType = new ARecordType(splits.get(k), new String[]{splits.get(k + 1)}, new IAType[]{AUnionType.createUnknownableType((IAType)enforcedRecordType)}, true);
                    }
                    Pair gapPair = (Pair)nestedTypeStack.pop();
                    ARecordType parent = (ARecordType)TypeComputeUtils.getActualType((IAType)((IAType)gapPair.first));
                    IAType[] parentFieldTypes = (IAType[])ArrayUtils.addAll((Object[])((Object[])parent.getFieldTypes().clone()), (Object[])new IAType[]{AUnionType.createUnknownableType((IAType)enforcedRecordType)});
                    enforcedRecordType = new ARecordType(bridgeName, (String[])ArrayUtils.addAll((Object[])parent.getFieldNames(), (Object[])new String[]{enforcedRecordType.getTypeName()}), parentFieldTypes, true);
                    enforcedRecordType = TypeUtil.keepUnknown((IAType)gapPair.first, enforcedRecordType);
                } else {
                    ARecordType lastNestedRecord = (ARecordType)TypeComputeUtils.getActualType((IAType)nestedFieldType);
                    Map<String, IAType> recordNameTypesMap = TypeUtil.createRecordNameTypeMap(lastNestedRecord);
                    IAType enforcedFieldType = recordNameTypesMap.get(splits.get(splits.size() - 1));
                    if (enforcedFieldType != null && enforcedFieldType.getTypeTag() == ATypeTag.UNION && ((AUnionType)enforcedFieldType).isUnknownableType()) {
                        enforcedFieldType = ((AUnionType)enforcedFieldType).getActualType();
                    }
                    if (enforcedFieldType != null && !ATypeHierarchy.canPromote((ATypeTag)enforcedFieldType.getTypeTag(), (ATypeTag)index.getKeyFieldTypes().get(i).getTypeTag())) {
                        throw new AsterixException(1079, new Serializable[]{"Cannot enforce field \"" + String.join((CharSequence)".", (Iterable<? extends CharSequence>)index.getKeyFieldNames().get(i)) + "\" to have type " + index.getKeyFieldTypes().get(i)});
                    }
                    if (enforcedFieldType == null) {
                        recordNameTypesMap.put(splits.get(splits.size() - 1), AUnionType.createUnknownableType((IAType)index.getKeyFieldTypes().get(i)));
                    }
                    enforcedRecordType = new ARecordType(lastNestedRecord.getTypeName(), recordNameTypesMap.keySet().toArray(new String[recordNameTypesMap.size()]), recordNameTypesMap.values().toArray(new IAType[recordNameTypesMap.size()]), lastNestedRecord.isOpen());
                    enforcedRecordType = TypeUtil.keepUnknown((IAType)nestedFieldType, enforcedRecordType);
                }
                if (nestedTypeStack.isEmpty()) continue;
                while (!nestedTypeStack.isEmpty()) {
                    Pair nestedType = (Pair)nestedTypeStack.pop();
                    ARecordType nestedRecType = (ARecordType)TypeComputeUtils.getActualType((IAType)((IAType)nestedType.first));
                    IAType[] nestedRecTypeFieldTypes = (IAType[])nestedRecType.getFieldTypes().clone();
                    nestedRecTypeFieldTypes[nestedRecType.getFieldIndex((String)((String)nestedType.second))] = enforcedRecordType;
                    enforcedRecordType = new ARecordType(nestedRecType.getTypeName() + "_enforced", nestedRecType.getFieldNames(), nestedRecTypeFieldTypes, nestedRecType.isOpen());
                    enforcedRecordType = TypeUtil.keepUnknown((IAType)nestedType.first, enforcedRecordType);
                }
            }
        }
        TypeUtil.validateRecord((IAType)enforcedRecordType);
        return new Pair((Object)enforcedRecordType, (Object)enforcedMetaType);
    }

    private static Map<String, IAType> createRecordNameTypeMap(ARecordType recordType) {
        LinkedHashMap<String, IAType> recordNameTypesMap = new LinkedHashMap<String, IAType>();
        for (int j = 0; j < recordType.getFieldNames().length; ++j) {
            recordNameTypesMap.put(recordType.getFieldNames()[j], recordType.getFieldTypes()[j]);
        }
        return recordNameTypesMap;
    }

    private static IAType keepUnknown(IAType originalRecordType, ARecordType updatedRecordType) {
        if (originalRecordType.getTypeTag() == ATypeTag.UNION) {
            return AUnionType.createUnknownableType((IAType)updatedRecordType, (String)updatedRecordType.getTypeName());
        }
        return updatedRecordType;
    }

    private static void validateRecord(IAType enforcedDatasetRecordType) {
        if (enforcedDatasetRecordType.getTypeTag() != ATypeTag.OBJECT) {
            throw new IllegalStateException("The dataset type must be a record type to be able to build an index");
        }
    }

    private static void validateNestedRecord(IAType nestedRecordType, List<String> fieldName) throws AsterixException {
        IAType actualType = TypeComputeUtils.getActualType((IAType)nestedRecordType);
        if (actualType.getTypeTag() != ATypeTag.OBJECT) {
            String fName = String.join((CharSequence)".", fieldName);
            throw new AsterixException(1079, new Serializable[]{"Field accessor is not defined for \"" + fName + "\" of type " + actualType.getTypeTag()});
        }
    }
}

