/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.DataOutput;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.context.ITransactionSubsystemProvider;
import org.apache.asterix.common.context.TransactionSubsystemProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.operators.LSMPrimaryUpsertOperatorDescriptor;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexInstantSearchOperationCallbackFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.misc.ConstantTupleSourceOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IIndexBuilderFactory;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.build.IndexBuilderFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexCreateOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMTreeIndexCompactOperatorDescriptor;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatasetUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final byte OP_UPSERT = 3;

    private DatasetUtil() {
    }

    public static List<String> getFilterField(Dataset dataset) {
        return ((InternalDatasetDetails)dataset.getDatasetDetails()).getFilterField();
    }

    public static IBinaryComparatorFactory[] computeFilterBinaryComparatorFactories(Dataset dataset, ARecordType itemType, IBinaryComparatorFactoryProvider comparatorFactoryProvider) throws AlgebricksException {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return null;
        }
        List<String> filterField = DatasetUtil.getFilterField(dataset);
        if (filterField == null) {
            return null;
        }
        IBinaryComparatorFactory[] bcfs = new IBinaryComparatorFactory[1];
        IAType type = itemType.getSubFieldType(filterField);
        bcfs[0] = comparatorFactoryProvider.getBinaryComparatorFactory((Object)type, true);
        return bcfs;
    }

    public static ITypeTraits[] computeFilterTypeTraits(Dataset dataset, ARecordType itemType) throws AlgebricksException {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return null;
        }
        List<String> filterField = DatasetUtil.getFilterField(dataset);
        if (filterField == null) {
            return null;
        }
        ITypeTraits[] typeTraits = new ITypeTraits[1];
        IAType type = itemType.getSubFieldType(filterField);
        typeTraits[0] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)type);
        return typeTraits;
    }

    public static int[] createFilterFields(Dataset dataset) throws AlgebricksException {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return null;
        }
        List<String> filterField = DatasetUtil.getFilterField(dataset);
        if (filterField == null) {
            return null;
        }
        List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
        int numKeys = partitioningKeys.size();
        int[] filterFields = new int[]{numKeys + 1};
        return filterFields;
    }

    public static int[] createBTreeFieldsWhenThereisAFilter(Dataset dataset) throws AlgebricksException {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return null;
        }
        List<String> filterField = DatasetUtil.getFilterField(dataset);
        if (filterField == null) {
            return null;
        }
        List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
        int valueFields = dataset.hasMetaPart() ? 2 : 1;
        int[] btreeFields = new int[partitioningKeys.size() + valueFields];
        for (int i = 0; i < btreeFields.length; ++i) {
            btreeFields[i] = i;
        }
        return btreeFields;
    }

    public static int getPositionOfPartitioningKeyField(Dataset dataset, List<String> fieldExpr) {
        List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
        for (int i = 0; i < partitioningKeys.size(); ++i) {
            List<String> partitioningKey = partitioningKeys.get(i);
            if (!partitioningKey.equals(fieldExpr)) continue;
            return i;
        }
        return -1;
    }

    public static Pair<ILSMMergePolicyFactory, Map<String, String>> getMergePolicyFactory(Dataset dataset, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        ILSMMergePolicyFactory mergePolicyFactory;
        String policyName = dataset.getCompactionPolicy();
        CompactionPolicy compactionPolicy = MetadataManager.INSTANCE.getCompactionPolicy(mdTxnCtx, "Metadata", policyName);
        String compactionPolicyFactoryClassName = compactionPolicy.getClassName();
        Map<String, String> properties = dataset.getCompactionPolicyProperties();
        try {
            mergePolicyFactory = (ILSMMergePolicyFactory)Class.forName(compactionPolicyFactoryClassName).newInstance();
            if (mergePolicyFactory.getName().compareTo("correlated-prefix") == 0) {
                properties.put("datasetId", Integer.toString(dataset.getDatasetId()));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)mergePolicyFactory, properties);
    }

    public static void writePropertyTypeRecord(String name, String value, DataOutput out, ARecordType recordType) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(recordType);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        fieldValue.reset();
        aString.setValue(name);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }

    public static ARecordType getMetaType(MetadataProvider metadataProvider, Dataset dataset) throws AlgebricksException {
        if (dataset.hasMetaPart()) {
            return (ARecordType)metadataProvider.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        }
        return null;
    }

    public static JobSpecification dropDatasetJobSpec(Dataset dataset, MetadataProvider metadataProvider) throws AlgebricksException, HyracksDataException, RemoteException, ACIDException {
        LOGGER.info("DROP DATASET: " + dataset);
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        }
        JobSpecification specPrimary = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
        IndexDropOperatorDescriptor primaryBtreeDrop = new IndexDropOperatorDescriptor((IOperatorDescriptorRegistry)specPrimary, (IIndexDataflowHelperFactory)indexHelperFactory);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)specPrimary, (IOperatorDescriptor)primaryBtreeDrop, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        specPrimary.addRoot((IOperatorDescriptor)primaryBtreeDrop);
        return specPrimary;
    }

    public static JobSpecification buildDropFilesIndexJobSpec(MetadataProvider metadataProvider, Dataset dataset) throws AlgebricksException {
        String indexName = IndexingConstants.getFilesIndexName((String)dataset.getDatasetName());
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset, indexName);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
        IndexDropOperatorDescriptor btreeDrop = new IndexDropOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexDataflowHelperFactory)indexHelperFactory);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)btreeDrop, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        spec.addRoot((IOperatorDescriptor)btreeDrop);
        return spec;
    }

    public static JobSpecification createDatasetJobSpec(Dataset dataset, MetadataProvider metadataProvider) throws AlgebricksException {
        Index index = IndexUtil.getPrimaryIndex(dataset);
        ARecordType itemType = (ARecordType)metadataProvider.findType(dataset);
        ARecordType metaItemType = null;
        if (dataset.hasMetaPart()) {
            metaItemType = (ARecordType)metadataProvider.findMetaType(dataset);
        }
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset);
        FileSplit[] fs = ((IFileSplitProvider)splitsAndConstraint.first).getFileSplits();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fs.length; ++i) {
            sb.append(fs[i] + " ");
        }
        LOGGER.info("CREATING File Splits: " + sb.toString());
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(dataset, metadataProvider.getMetadataTxnContext());
        IResourceFactory resourceFactory = dataset.getResourceFactory(metadataProvider, index, itemType, metaItemType, (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second);
        IndexBuilderFactory indexBuilderFactory = new IndexBuilderFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first, resourceFactory, true);
        IndexCreateOperatorDescriptor indexCreateOp = new IndexCreateOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexBuilderFactory)indexBuilderFactory);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)indexCreateOp, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        spec.addRoot((IOperatorDescriptor)indexCreateOp);
        return spec;
    }

    public static JobSpecification compactDatasetJobSpec(Dataverse dataverse, String datasetName, MetadataProvider metadataProvider) throws AlgebricksException {
        String dataverseName = dataverse.getDataverseName();
        Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new AsterixException("Could not find dataset " + datasetName + " in dataverse " + dataverseName);
        }
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
        LSMTreeIndexCompactOperatorDescriptor compactOp = new LSMTreeIndexCompactOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexDataflowHelperFactory)indexHelperFactory);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)compactOp, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)compactOp, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        spec.addRoot((IOperatorDescriptor)compactOp);
        return spec;
    }

    public static IOperatorDescriptor createPrimaryIndexScanOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset dataset) throws AlgebricksException {
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> primarySplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset);
        IFileSplitProvider primaryFileSplitProvider = (IFileSplitProvider)primarySplitsAndConstraint.first;
        AlgebricksPartitionConstraint primaryPartitionConstraint = (AlgebricksPartitionConstraint)primarySplitsAndConstraint.second;
        int[] lowKeyFields = null;
        int[] highKeyFields = null;
        TransactionSubsystemProvider txnSubsystemProvider = TransactionSubsystemProvider.INSTANCE;
        PrimaryIndexInstantSearchOperationCallbackFactory searchCallbackFactory = new PrimaryIndexInstantSearchOperationCallbackFactory(dataset.getDatasetId(), dataset.getPrimaryBloomFilterFields(), (ITransactionSubsystemProvider)txnSubsystemProvider, 0);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), primaryFileSplitProvider);
        BTreeSearchOperatorDescriptor primarySearchOp = new BTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)spec, dataset.getPrimaryRecordDescriptor(metadataProvider), lowKeyFields, highKeyFields, true, true, (IIndexDataflowHelperFactory)indexHelperFactory, false, false, null, (ISearchOperationCallbackFactory)searchCallbackFactory, null, null, false);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)primarySearchOp, (AlgebricksPartitionConstraint)primaryPartitionConstraint);
        return primarySearchOp;
    }

    public static Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> createPrimaryIndexUpsertOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset dataset, RecordDescriptor inputRecordDesc, int[] fieldPermutation, IMissingWriterFactory missingWriterFactory) throws AlgebricksException {
        int numKeys = dataset.getPrimaryKeys().size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        ARecordType itemType = (ARecordType)metadataProvider.findType(dataset);
        ARecordType metaItemType = (ARecordType)metadataProvider.findMetaType(dataset);
        Index primaryIndex = metadataProvider.getIndex(dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset);
        int[] primaryKeyFields = new int[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            primaryKeyFields[i] = i;
        }
        boolean hasSecondaries = metadataProvider.getDatasetIndexes(dataset.getDataverseName(), dataset.getDatasetName()).size() > 1;
        IStorageComponentProvider storageComponentProvider = metadataProvider.getStorageComponentProvider();
        IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(storageComponentProvider, primaryIndex, IndexOperation.UPSERT, primaryKeyFields);
        ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(storageComponentProvider, primaryIndex, IndexOperation.UPSERT, primaryKeyFields);
        IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
        ITypeTraits[] outputTypeTraits = new ITypeTraits[inputRecordDesc.getFieldCount() + 1 + (dataset.hasMetaPart() ? 2 : 1) + numFilterFields];
        ISerializerDeserializer[] outputSerDes = new ISerializerDeserializer[inputRecordDesc.getFieldCount() + 1 + (dataset.hasMetaPart() ? 2 : 1) + numFilterFields];
        IDataFormat dataFormat = metadataProvider.getDataFormat();
        int f = 0;
        outputSerDes[f] = dataFormat.getSerdeProvider().getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
        outputTypeTraits[f] = dataFormat.getTypeTraitProvider().getTypeTrait((Object)BuiltinType.ABOOLEAN);
        outputSerDes[++f] = dataFormat.getSerdeProvider().getSerializerDeserializer((Object)itemType);
        outputTypeTraits[f] = dataFormat.getTypeTraitProvider().getTypeTrait((Object)itemType);
        ++f;
        if (dataset.hasMetaPart()) {
            outputSerDes[f] = dataFormat.getSerdeProvider().getSerializerDeserializer((Object)metaItemType);
            outputTypeTraits[f] = dataFormat.getTypeTraitProvider().getTypeTrait((Object)metaItemType);
            ++f;
        }
        int fieldIdx = -1;
        if (numFilterFields > 0) {
            int i;
            String filterField = DatasetUtil.getFilterField(dataset).get(0);
            String[] fieldNames = itemType.getFieldNames();
            for (i = 0; i < fieldNames.length && !fieldNames[i].equals(filterField); ++i) {
            }
            fieldIdx = i;
            outputTypeTraits[f] = dataFormat.getTypeTraitProvider().getTypeTrait((Object)itemType.getFieldTypes()[fieldIdx]);
            outputSerDes[f] = dataFormat.getSerdeProvider().getSerializerDeserializer((Object)itemType.getFieldTypes()[fieldIdx]);
            ++f;
        }
        for (int j = 0; j < inputRecordDesc.getFieldCount(); ++j) {
            outputTypeTraits[j + f] = inputRecordDesc.getTypeTraits()[j];
            outputSerDes[j + f] = inputRecordDesc.getFields()[j];
        }
        RecordDescriptor outputRecordDesc = new RecordDescriptor(outputSerDes, outputTypeTraits);
        LSMPrimaryUpsertOperatorDescriptor op = new LSMPrimaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, outputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, missingWriterFactory, modificationCallbackFactory, searchCallbackFactory, dataset.getFrameOpCallbackFactory(metadataProvider), numKeys, itemType, fieldIdx, hasSecondaries);
        return new Pair((Object)op, splitsAndConstraint.second);
    }

    public static IOperatorDescriptor createDummyKeyProviderOp(JobSpecification spec, Dataset dataset, MetadataProvider metadataProvider) throws AlgebricksException {
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> primarySplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(dataset);
        AlgebricksPartitionConstraint primaryPartitionConstraint = (AlgebricksPartitionConstraint)primarySplitsAndConstraint.second;
        ArrayTupleBuilder tb = new ArrayTupleBuilder(1);
        DataOutput dos = tb.getDataOutput();
        tb.reset();
        try {
            IntegerSerializerDeserializer.INSTANCE.serialize(Integer.valueOf(0), dos);
        }
        catch (HyracksDataException e) {
            throw new AsterixException((Throwable)e);
        }
        tb.addFieldEndOffset();
        ISerializerDeserializer[] keyRecDescSers = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE};
        RecordDescriptor keyRecDesc = new RecordDescriptor(keyRecDescSers);
        ConstantTupleSourceOperatorDescriptor keyProviderOp = new ConstantTupleSourceOperatorDescriptor((IOperatorDescriptorRegistry)spec, keyRecDesc, tb.getFieldEndOffsets(), tb.getByteArray(), tb.getSize());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)keyProviderOp, (AlgebricksPartitionConstraint)primaryPartitionConstraint);
        return keyProviderOp;
    }

    public static boolean isFullyQualifiedName(String datasetName) {
        return datasetName.indexOf(46) > 0;
    }

    public static String getFullyQualifiedName(Dataset dataset) {
        return dataset.getDataverseName() + '.' + dataset.getDatasetName();
    }

    public static String createNodeGroupForNewDataset(String dataverseName, String datasetName, Set<String> ncNames, MetadataProvider metadataProvider) throws Exception {
        return DatasetUtil.createNodeGroupForNewDataset(dataverseName, datasetName, 0L, ncNames, metadataProvider);
    }

    public static String createNodeGroupForNewDataset(String dataverseName, String datasetName, long rebalanceCount, Set<String> ncNames, MetadataProvider metadataProvider) throws Exception {
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        String nodeGroup = dataverseName + "." + datasetName + (rebalanceCount == 0L ? "" : "_" + rebalanceCount);
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        appCtx.getMetadataLockManager().acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodeGroup);
        NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodeGroup);
        if (ng != null) {
            nodeGroup = nodeGroup + "_" + UUID.randomUUID().toString();
            appCtx.getMetadataLockManager().acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodeGroup);
        }
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, new NodeGroup(nodeGroup, new ArrayList<String>(ncNames)));
        return nodeGroup;
    }

    public static Pair<String, String> getDatasetInfo(MetadataProvider metadata, String datasetArg) {
        String second;
        String first;
        int i = datasetArg.indexOf(46);
        if (i > 0 && i < datasetArg.length() - 1) {
            first = datasetArg.substring(0, i);
            second = datasetArg.substring(i + 1);
        } else {
            first = metadata.getDefaultDataverse() == null ? null : metadata.getDefaultDataverse().getDataverseName();
            second = datasetArg;
        }
        return new Pair((Object)first, (Object)second);
    }
}

