/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.asterix.common.metadata.IMetadataLock;

public class MetadataLock
implements IMetadataLock {
    private final String key;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    public MetadataLock(String key) {
        this.key = key;
    }

    public void lock(IMetadataLock.Mode mode) {
        switch (mode) {
            case WRITE: {
                this.lock.writeLock().lock();
                break;
            }
            default: {
                this.lock.readLock().lock();
            }
        }
    }

    public void unlock(IMetadataLock.Mode mode) {
        switch (mode) {
            case WRITE: {
                this.lock.writeLock().unlock();
                break;
            }
            default: {
                this.lock.readLock().unlock();
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetadataLock)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return Objects.equals(this.key, ((MetadataLock)o).key);
    }

    public String toString() {
        return this.key;
    }
}

