/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.api.IDataSourceAdapter;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.provider.AdapterFactoryProvider;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;

public class FeedMetadataUtil {
    private FeedMetadataUtil() {
    }

    public static Dataset validateIfDatasetExists(MetadataProvider metadataProvider, String dataverse, String datasetName) throws AlgebricksException {
        Dataset dataset = metadataProvider.findDataset(dataverse, datasetName);
        if (dataset == null) {
            throw new CompilationException("Unknown target dataset :" + datasetName);
        }
        if (!dataset.getDatasetType().equals((Object)DatasetConfig.DatasetType.INTERNAL)) {
            throw new CompilationException("Statement not applicable. Dataset " + datasetName + " is not of required type " + DatasetConfig.DatasetType.INTERNAL);
        }
        return dataset;
    }

    public static Feed validateIfFeedExists(String dataverse, String feedName, MetadataTransactionContext ctx) throws AlgebricksException {
        Feed feed = MetadataManager.INSTANCE.getFeed(ctx, dataverse, feedName);
        if (feed == null) {
            throw new CompilationException("Unknown source feed: " + feedName);
        }
        return feed;
    }

    public static FeedPolicyEntity validateIfPolicyExists(String dataverse, String policyName, MetadataTransactionContext ctx) throws AlgebricksException {
        FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(ctx, dataverse, policyName);
        if (feedPolicy == null && (feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(ctx, "Metadata", policyName)) == null) {
            throw new CompilationException("Unknown feed policy" + policyName);
        }
        return feedPolicy;
    }

    public static void validateFeed(Feed feed, MetadataTransactionContext mdTxnCtx, ICcApplicationContext appCtx) throws AlgebricksException {
        try {
            Map<String, String> configuration = feed.getConfiguration();
            ARecordType adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration.get("type-name"));
            ARecordType metaType = FeedMetadataUtil.getOutputType(feed, configuration.get("meta-type-name"));
            ExternalDataUtils.prepareFeed(configuration, (String)feed.getDataverseName(), (String)feed.getFeedName());
            String adapterName = configuration.get("adapter-name");
            if (adapterName == null) {
                throw new AlgebricksException("cannot find adatper name");
            }
            DatasourceAdapter adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "Metadata", adapterName);
            if (adapterEntity == null) {
                adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, feed.getDataverseName(), adapterName);
            }
            if (adapterEntity != null) {
                IAdapterFactory adapterFactory;
                IDataSourceAdapter.AdapterType adapterType = adapterEntity.getType();
                String adapterFactoryClassname = adapterEntity.getClassname();
                switch (adapterType) {
                    case INTERNAL: {
                        adapterFactory = (IAdapterFactory)Class.forName(adapterFactoryClassname).newInstance();
                        break;
                    }
                    case EXTERNAL: {
                        String[] anameComponents = adapterName.split("#");
                        String libraryName = anameComponents[0];
                        ClassLoader cl = appCtx.getLibraryManager().getLibraryClassLoader(feed.getDataverseName(), libraryName);
                        adapterFactory = (IAdapterFactory)cl.loadClass(adapterFactoryClassname).newInstance();
                        break;
                    }
                    default: {
                        throw new AsterixException("Unknown Adapter type " + adapterType);
                    }
                }
                adapterFactory.setOutputType(adapterOutputType);
                adapterFactory.setMetaType(metaType);
                adapterFactory.configure((IServiceContext)appCtx.getServiceContext(), configuration);
            } else {
                AdapterFactoryProvider.getAdapterFactory((IServiceContext)appCtx.getServiceContext(), (String)adapterName, configuration, (ARecordType)adapterOutputType, (ARecordType)metaType);
            }
            if (metaType == null && configuration.containsKey("meta-type-name") && (metaType = FeedMetadataUtil.getOutputType(feed, configuration.get("meta-type-name"))) == null) {
                throw new AsterixException("Unknown specified feed meta output data type " + configuration.get("meta-type-name"));
            }
            if (adapterOutputType == null) {
                if (!configuration.containsKey("type-name")) {
                    throw new AsterixException("Unspecified feed output data type");
                }
                adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration.get("type-name"));
                if (adapterOutputType == null) {
                    throw new AsterixException("Unknown specified feed output data type " + configuration.get("type-name"));
                }
            }
        }
        catch (Exception e) {
            throw new AsterixException("Invalid feed parameters. Exception Message:" + e.getMessage(), (Throwable)e);
        }
    }

    public static Triple<IAdapterFactory, RecordDescriptor, IDataSourceAdapter.AdapterType> getFeedFactoryAndOutput(Feed feed, FeedPolicyAccessor policyAccessor, MetadataTransactionContext mdTxnCtx, ICcApplicationContext appCtx) throws AlgebricksException {
        String adapterName = null;
        DatasourceAdapter adapterEntity = null;
        String adapterFactoryClassname = null;
        IAdapterFactory adapterFactory = null;
        ARecordType adapterOutputType = null;
        ARecordType metaType = null;
        Triple feedProps = null;
        IDataSourceAdapter.AdapterType adapterType = null;
        try {
            Map<String, String> configuration = feed.getConfiguration();
            adapterName = configuration.get("adapter-name");
            configuration.putAll(policyAccessor.getFeedPolicy());
            adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration.get("type-name"));
            metaType = FeedMetadataUtil.getOutputType(feed, configuration.get("meta-type-name"));
            ExternalDataUtils.prepareFeed(configuration, (String)feed.getDataverseName(), (String)feed.getFeedName());
            adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "Metadata", adapterName);
            if (adapterEntity == null) {
                adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, feed.getDataverseName(), adapterName);
            }
            if (adapterEntity != null) {
                adapterType = adapterEntity.getType();
                adapterFactoryClassname = adapterEntity.getClassname();
                switch (adapterType) {
                    case INTERNAL: {
                        adapterFactory = (IAdapterFactory)Class.forName(adapterFactoryClassname).newInstance();
                        break;
                    }
                    case EXTERNAL: {
                        String[] anameComponents = adapterName.split("#");
                        String libraryName = anameComponents[0];
                        ClassLoader cl = appCtx.getLibraryManager().getLibraryClassLoader(feed.getDataverseName(), libraryName);
                        adapterFactory = (IAdapterFactory)cl.loadClass(adapterFactoryClassname).newInstance();
                        break;
                    }
                    default: {
                        throw new AsterixException("Unknown Adapter type " + adapterType);
                    }
                }
                adapterFactory.setOutputType(adapterOutputType);
                adapterFactory.setMetaType(metaType);
                adapterFactory.configure((IServiceContext)appCtx.getServiceContext(), configuration);
            } else {
                adapterFactory = AdapterFactoryProvider.getAdapterFactory((IServiceContext)appCtx.getServiceContext(), (String)adapterName, configuration, (ARecordType)adapterOutputType, (ARecordType)metaType);
                adapterType = IDataSourceAdapter.AdapterType.INTERNAL;
            }
            if (metaType == null) {
                metaType = FeedMetadataUtil.getOutputType(feed, configuration.get("meta-type-name"));
            }
            if (adapterOutputType == null) {
                if (!configuration.containsKey("type-name")) {
                    throw new AsterixException("Unspecified feed output data type");
                }
                adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration.get("type-name"));
            }
            int numOfOutputs = 1;
            if (metaType != null) {
                ++numOfOutputs;
            }
            if (ExternalDataUtils.isChangeFeed(configuration)) {
                numOfOutputs += ExternalDataUtils.getNumberOfKeys(configuration);
            }
            ISerializerDeserializer[] serdes = new ISerializerDeserializer[numOfOutputs];
            int i = 0;
            serdes[i++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType);
            if (metaType != null) {
                serdes[i++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)metaType);
            }
            if (ExternalDataUtils.isChangeFeed(configuration)) {
                FeedMetadataUtil.getSerdesForPKs(serdes, configuration, metaType, adapterOutputType, i);
            }
            feedProps = new Triple((Object)adapterFactory, (Object)new RecordDescriptor(serdes), (Object)adapterType);
        }
        catch (Exception e) {
            throw new AlgebricksException("unable to create adapter", (Throwable)e);
        }
        return feedProps;
    }

    private static void getSerdesForPKs(ISerializerDeserializer[] serdes, Map<String, String> configuration, ARecordType metaType, ARecordType adapterOutputType, int index) throws AlgebricksException {
        int[] pkIndexes = ExternalDataUtils.getPKIndexes(configuration);
        if (metaType != null) {
            int[] pkIndicators = ExternalDataUtils.getPKSourceIndicators(configuration);
            for (int j = 0; j < pkIndexes.length; ++j) {
                int aInt = pkIndexes[j];
                if (pkIndicators[j] == 0) {
                    serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType.getFieldTypes()[aInt]);
                    continue;
                }
                if (pkIndicators[j] == 1) {
                    serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)metaType.getFieldTypes()[aInt]);
                    continue;
                }
                throw new AlgebricksException("a key source indicator can only be 0 or 1");
            }
        } else {
            for (int aInt : pkIndexes) {
                serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType.getFieldTypes()[aInt]);
            }
        }
    }

    public static ARecordType getOutputType(IFeed feed, String fqOutputType) throws AlgebricksException {
        ARecordType outputType;
        block10: {
            String dataverseName;
            String datatypeName;
            outputType = null;
            if (fqOutputType == null) {
                return null;
            }
            String[] dataverseAndType = fqOutputType.split("[.]");
            if (dataverseAndType.length == 1) {
                datatypeName = dataverseAndType[0];
                dataverseName = feed.getDataverseName();
            } else if (dataverseAndType.length == 2) {
                dataverseName = dataverseAndType[0];
                datatypeName = dataverseAndType[1];
            } else {
                throw new IllegalArgumentException("Invalid parameter value " + fqOutputType);
            }
            MetadataTransactionContext ctx = null;
            try {
                ctx = MetadataManager.INSTANCE.beginTransaction();
                Datatype t = MetadataManager.INSTANCE.getDatatype(ctx, dataverseName, datatypeName);
                if (t == null || t.getDatatype().getTypeTag() != ATypeTag.OBJECT) {
                    throw new MetadataException(3080, new Serializable[]{datatypeName});
                }
                outputType = (ARecordType)t.getDatatype();
                MetadataManager.INSTANCE.commitTransaction(ctx);
            }
            catch (RemoteException | ACIDException e) {
                if (ctx == null) break block10;
                try {
                    MetadataManager.INSTANCE.abortTransaction(ctx);
                }
                catch (RemoteException | ACIDException e2) {
                    e.addSuppressed(e2);
                }
                throw new MetadataException(3009, e, new Serializable[]{datatypeName});
            }
        }
        return outputType;
    }
}

