/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Date;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class ExternalFileTupleTranslator
extends AbstractTupleTranslator<ExternalFile> {
    private static final long serialVersionUID = -4966958481117396312L;
    public static final int EXTERNAL_FILE_DATAVERSENAME_TUPLE_FIELD_INDEX = 0;
    public static final int EXTERNAL_FILE_DATASETNAME_TUPLE_FIELD_INDEX = 1;
    public static final int EXTERNAL_FILE_NUMBER_TUPLE_FIELD_INDEX = 2;
    public static final int EXTERNAL_FILE_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    protected transient AMutableInt32 aInt32 = new AMutableInt32(0);
    protected transient AMutableDateTime aDateTime = new AMutableDateTime(0L);
    protected transient AMutableInt64 aInt64 = new AMutableInt64(0L);
    protected ISerializerDeserializer<AInt32> intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    protected ISerializerDeserializer<ADateTime> dateTimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
    protected ISerializerDeserializer<AInt64> longSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.EXTERNAL_FILE_RECORDTYPE);

    protected ExternalFileTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET.getFieldCount());
    }

    @Override
    public ExternalFile getMetadataEntityFromTuple(ITupleReference tuple) throws AlgebricksException, HyracksDataException {
        byte[] serRecord = tuple.getFieldData(3);
        int recordStartOffset = tuple.getFieldStart(3);
        int recordLength = tuple.getFieldLength(3);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord externalFileRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createExternalFileFromARecord(externalFileRecord);
    }

    private ExternalFile createExternalFileFromARecord(ARecord externalFileRecord) {
        String dataverseName = ((AString)externalFileRecord.getValueByPos(0)).getStringValue();
        String datasetName = ((AString)externalFileRecord.getValueByPos(1)).getStringValue();
        int fileNumber = ((AInt32)externalFileRecord.getValueByPos(2)).getIntegerValue();
        String fileName = ((AString)externalFileRecord.getValueByPos(3)).getStringValue();
        long fileSize = ((AInt64)externalFileRecord.getValueByPos(4)).getLongValue();
        Date lastMoDifiedDate = new Date(((ADateTime)externalFileRecord.getValueByPos(5)).getChrononTime());
        DatasetConfig.ExternalFilePendingOp pendingOp = DatasetConfig.ExternalFilePendingOp.values()[((AInt32)externalFileRecord.getValueByPos(6)).getIntegerValue()];
        return new ExternalFile(dataverseName, datasetName, fileNumber, fileName, lastMoDifiedDate, fileSize, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(ExternalFile externalFile) throws AlgebricksException, HyracksDataException {
        this.tupleBuilder.reset();
        this.aString.setValue(externalFile.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(externalFile.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aInt32.setValue(externalFile.getFileNumber());
        this.intSerde.serialize((Object)this.aInt32, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.EXTERNAL_FILE_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(externalFile.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(externalFile.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(externalFile.getFileNumber());
        this.intSerde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(externalFile.getFileName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt64.setValue(externalFile.getSize());
        this.longSerde.serialize((Object)this.aInt64, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aDateTime.setValue(externalFile.getLastModefiedTime().getTime());
        this.dateTimeSerde.serialize((Object)this.aDateTime, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(externalFile.getPendingOp().ordinal());
        this.intSerde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

