/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class CompactionPolicyTupleTranslator
extends AbstractTupleTranslator<CompactionPolicy> {
    private static final long serialVersionUID = 5291424952240239023L;
    public static final int COMPACTION_POLICY_DATAVERSE_NAME_FIELD_INDEX = 0;
    public static final int COMPACTION_POLICY_NAME_FIELD_INDEX = 1;
    public static final int COMPACTION_POLICY_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    private ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.COMPACTION_POLICY_RECORDTYPE);

    protected CompactionPolicyTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET.getFieldCount());
    }

    @Override
    public CompactionPolicy getMetadataEntityFromTuple(ITupleReference tuple) throws HyracksDataException {
        byte[] serRecord = tuple.getFieldData(2);
        int recordStartOffset = tuple.getFieldStart(2);
        int recordLength = tuple.getFieldLength(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord compactionPolicyRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createCompactionPolicyFromARecord(compactionPolicyRecord);
    }

    private CompactionPolicy createCompactionPolicyFromARecord(ARecord compactionPolicyRecord) {
        CompactionPolicy compactionPolicy = null;
        String dataverseName = ((AString)compactionPolicyRecord.getValueByPos(0)).getStringValue();
        String policyName = ((AString)compactionPolicyRecord.getValueByPos(1)).getStringValue();
        String className = ((AString)compactionPolicyRecord.getValueByPos(2)).getStringValue();
        compactionPolicy = new CompactionPolicy(dataverseName, policyName, className);
        return compactionPolicy;
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(CompactionPolicy compactionPolicy) throws HyracksDataException, AlgebricksException {
        this.tupleBuilder.reset();
        this.aString.setValue(compactionPolicy.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(compactionPolicy.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.COMPACTION_POLICY_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(compactionPolicy.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(compactionPolicy.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(compactionPolicy.getClassName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

