/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFilters;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.common.SimilarityFiltersCache;
import org.apache.asterix.runtime.evaluators.functions.PrefixLenDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.PrefixLenDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class PrefixLenDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable inputVal = new VoidPointable();
    private final IScalarEvaluator evalLen;
    private final IScalarEvaluator evalSimilarity;
    private final IScalarEvaluator evalThreshold;
    private final SimilarityFiltersCache similarityFiltersCache;
    private final AMutableInt32 res;
    private final ISerializerDeserializer<AInt32> int32Serde;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ PrefixLenDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    PrefixLenDescriptor$_EvaluatorGen(PrefixLenDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.evalLen = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.evalSimilarity = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.evalThreshold = this.this$1.val$args[2].createScalarEvaluator(this.val$ctx);
        this.similarityFiltersCache = new SimilarityFiltersCache();
        this.res = new AMutableInt32(0);
        this.int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.evalLen.evaluate(tuple, this.inputVal);
        if (this.typeChecker.isMissing(this.inputVal, result)) {
            return;
        }
        byte[] data = this.inputVal.getByteArray();
        if (data[offset = this.inputVal.getStartOffset()] != ATypeTag.SERIALIZED_INT32_TYPE_TAG) {
            throw new TypeMismatchException(PrefixLenDescriptor$_Gen.access$000(this.this$1.this$0), this.this$1.this$0.getIdentifier(), Integer.valueOf(0), data[offset], new byte[]{ATypeTag.SERIALIZED_INT32_TYPE_TAG});
        }
        int length = IntegerPointable.getInteger((byte[])data, (int)(offset + 1));
        this.evalThreshold.evaluate(tuple, this.inputVal);
        if (this.typeChecker.isMissing(this.inputVal, result)) {
            return;
        }
        data = this.inputVal.getByteArray();
        if (data[offset = this.inputVal.getStartOffset()] != ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
            throw new TypeMismatchException(PrefixLenDescriptor$_Gen.access$100(this.this$1.this$0), this.this$1.this$0.getIdentifier(), Integer.valueOf(1), data[offset], new byte[]{ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG});
        }
        float similarityThreshold = (float)ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1));
        this.evalSimilarity.evaluate(tuple, this.inputVal);
        if (this.typeChecker.isMissing(this.inputVal, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        data = this.inputVal.getByteArray();
        offset = this.inputVal.getStartOffset();
        int len = this.inputVal.getLength();
        if (data[offset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(PrefixLenDescriptor$_Gen.access$200(this.this$1.this$0), this.this$1.this$0.getIdentifier(), Integer.valueOf(2), data[offset], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
        }
        SimilarityFilters similarityFilters = this.similarityFiltersCache.get(similarityThreshold, data, offset, len);
        int prefixLength = similarityFilters.getPrefixLength(length);
        this.res.setValue(prefixLength);
        try {
            this.int32Serde.serialize((Object)this.res, this.out);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

